/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.iteaj.iot.client.ClientConnectProperties;

public class SerialConnectProperties
extends ClientConnectProperties {
    private int safetySleepTime;
    private boolean useRS485Mode;
    private int sendDeviceQueueSize;
    private int receiveDeviceQueueSize;
    private int baudRate = 9600;
    private int dataBits = 8;
    private int parity = 0;
    private int stopBits = 1;

    public SerialConnectProperties(String com) {
        this(com, 100);
    }

    public SerialConnectProperties(String com, int safetySleepTime) {
        this(com, safetySleepTime, 4096, 4096);
    }

    public SerialConnectProperties(String com, int safetySleepTime, int sendDeviceQueueSize, int receiveDeviceQueueSize) {
        super(com, Integer.valueOf(0), com);
        this.setReaderIdleTime(3L);
        this.setWriterIdleTime(3L);
        this.safetySleepTime = safetySleepTime;
        this.sendDeviceQueueSize = sendDeviceQueueSize;
        this.receiveDeviceQueueSize = receiveDeviceQueueSize;
    }

    public String toString() {
        return this.connectKey();
    }

    public SerialConnectProperties config(int dataBits, int stopBits, int parity) {
        this.parity = parity;
        this.dataBits = dataBits;
        this.stopBits = stopBits;
        return this;
    }

    public SerialConnectProperties config(int baudRate, int dataBits, int stopBits, int parity) {
        this.parity = parity;
        this.dataBits = dataBits;
        this.baudRate = baudRate;
        this.stopBits = stopBits;
        return this;
    }

    public boolean isUseRS485Mode() {
        return this.useRS485Mode;
    }

    public SerialConnectProperties setUseRS485Mode(boolean useRS485Mode) {
        this.useRS485Mode = useRS485Mode;
        return this;
    }

    public int getBaudRate() {
        return this.baudRate;
    }

    public SerialConnectProperties setBaudRate(int baudRate) {
        this.baudRate = baudRate;
        return this;
    }

    public SerialConnectProperties setDataBits(int dataBits) {
        this.dataBits = dataBits;
        return this;
    }

    public SerialConnectProperties setStopBits(int stopBits) {
        this.stopBits = stopBits;
        return this;
    }

    public SerialConnectProperties setParity(int parity) {
        this.parity = parity;
        return this;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public int getSafetySleepTime() {
        return this.safetySleepTime;
    }

    public int getSendDeviceQueueSize() {
        return this.sendDeviceQueueSize;
    }

    public int getReceiveDeviceQueueSize() {
        return this.receiveDeviceQueueSize;
    }
}

