/*
 * Decompiled with CFR 0.152.
 */
package com.iteaj.iot.serial;

import com.iteaj.iot.ProtocolHandle;
import com.iteaj.iot.serial.SerialEventProtocol;
import com.iteaj.iot.utils.ByteUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface SerialEventProtocolHandle
extends ProtocolHandle<SerialEventProtocol> {
    public static final SerialEventProtocolHandle LOGGER_HANDLE = new LoggerSerialProtocolHandle();

    default public Object handle(SerialEventProtocol protocol) {
        try {
            if (protocol.getEvent() != null) {
                int eventType = protocol.getEvent().getEventType();
                switch (eventType) {
                    case 16: {
                        this.readEvent(protocol.getEvent().getReceivedData(), protocol);
                        break;
                    }
                    case 256: {
                        this.writeEvent(protocol);
                        break;
                    }
                    case 0: {
                        this.timeoutEvent(protocol);
                        break;
                    }
                    case 0x1E10000: {
                        this.errorEvent(protocol);
                        break;
                    }
                    case 524288: {
                        this.dataSetReadyEvent(protocol);
                        break;
                    }
                    case 0x10000000: {
                        this.disconnectedEvent(protocol);
                        break;
                    }
                    default: {
                        this.otherEvent(eventType, protocol);
                        break;
                    }
                }
            } else {
                this.errorEvent(protocol);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    default public void disconnectedEvent(SerialEventProtocol protocol) {
    }

    default public void otherEvent(int eventType, SerialEventProtocol protocol) {
    }

    public void readEvent(byte[] var1, SerialEventProtocol var2);

    default public void writeEvent(SerialEventProtocol protocol) {
    }

    default public void timeoutEvent(SerialEventProtocol protocol) {
    }

    default public void dataSetReadyEvent(SerialEventProtocol protocol) {
    }

    default public void errorEvent(SerialEventProtocol protocol) {
    }

    public static class LoggerSerialProtocolHandle
    implements SerialEventProtocolHandle {
        private Logger logger = LoggerFactory.getLogger(LoggerSerialProtocolHandle.class);

        @Override
        public void readEvent(byte[] receivedData, SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u63a5\u6536\u4e8b\u4ef6");
        }

        @Override
        public void writeEvent(SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u5199\u4e8b\u4ef6");
        }

        @Override
        public void disconnectedEvent(SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u65ad\u5f00\u4e8b\u4ef6");
        }

        @Override
        public void otherEvent(int eventType, SerialEventProtocol protocol) {
            this.printLogger(protocol, eventType + "");
        }

        @Override
        public void timeoutEvent(SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u8d85\u65f6\u4e8b\u4ef6");
        }

        @Override
        public void dataSetReadyEvent(SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u6570\u636e\u51c6\u5907\u597d\u4e8b\u4ef6");
        }

        @Override
        public void errorEvent(SerialEventProtocol protocol) {
            this.printLogger(protocol, "\u5f02\u5e38\u4e8b\u4ef6");
        }

        public void printLogger(SerialEventProtocol protocol, String event) {
            if (this.logger.isInfoEnabled()) {
                String data = ByteUtil.bytesToHexByFormat((byte[])protocol.getEvent().getReceivedData());
                this.logger.info("\u4e32\u53e3 \u76d1\u542c\u5230\u4e8b\u4ef6({}) - \u4e32\u53e3: {} - \u6570\u636e: {}", new Object[]{event, protocol.getConnectProperties(), data});
            }
        }
    }
}

