/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib;

import com.itemis.fluffyj.exceptions.InstantiationNotPermittedException;
import com.itemis.jscdlib.SCardLibHandle;
import com.itemis.jscdlib.ScDaemonHandle;
import com.itemis.jscdlib.discovery.JScdEnvSocketDiscovery;
import com.itemis.jscdlib.discovery.JScdGpgConfSocketDiscovery;
import com.itemis.jscdlib.internal.OsDetector;
import com.itemis.jscdlib.internal.ScDaemonNativeBridge;
import com.itemis.jscdlib.internal.ScardLibNativeBridge;
import java.lang.foreign.Arena;
import java.lang.foreign.SymbolLookup;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JScdLib {
    private static final Logger LOG = LoggerFactory.getLogger(JScdLib.class);
    private static final boolean IS_WINDOWS;
    private static final boolean IS_MAC;
    private static final Set<String> LINUX_SCDAEMON_LIB_CANDIDATES;
    private static final Set<String> LINUX_SCARD_LIB_CANDIDATES;

    private JScdLib() {
        throw new InstantiationNotPermittedException();
    }

    public static SCardLibHandle constructSCardHandle() {
        ScardLibNativeBridge bridge = null;
        bridge = IS_WINDOWS ? new ScardLibNativeBridge(arena -> SymbolLookup.libraryLookup("winscard", arena)) : (IS_MAC ? new ScardLibNativeBridge(arena -> SymbolLookup.libraryLookup("/System/Library/Frameworks/PCSC.framework/PCSC", arena)) : new ScardLibNativeBridge(arena -> JScdLib.loadLinuxLib(LINUX_SCARD_LIB_CANDIDATES, arena)));
        return new SCardLibHandle(bridge);
    }

    public static ScDaemonHandle constructScDaemonHandle() {
        ScDaemonNativeBridge bridge = null;
        bridge = IS_WINDOWS ? new ScDaemonNativeBridge(arena -> SymbolLookup.libraryLookup("libassuan6-0", arena)) : (IS_MAC ? new ScDaemonNativeBridge(arena -> SymbolLookup.libraryLookup("libassuan", arena)) : new ScDaemonNativeBridge(arena -> JScdLib.loadLinuxLib(LINUX_SCDAEMON_LIB_CANDIDATES, arena)));
        return new ScDaemonHandle(bridge, new JScdGpgConfSocketDiscovery(new JScdEnvSocketDiscovery()));
    }

    private static SymbolLookup loadLinuxLib(Iterable<String> libNameCandidates, Arena arena) {
        SymbolLookup result = null;
        Iterator<String> candidateIter = libNameCandidates.iterator();
        while (candidateIter.hasNext()) {
            String candidate = candidateIter.next();
            try {
                result = SymbolLookup.libraryLookup(candidate, arena);
            }
            catch (IllegalArgumentException e) {
                String msg = "Could not get a handle on lib.";
                if (!candidateIter.hasNext()) {
                    LOG.error("Could not get a handle on lib. Giving up.", (Throwable)e);
                    throw e;
                }
                LOG.debug("Could not get a handle on lib.", (Throwable)e);
            }
        }
        return result;
    }

    static {
        OsDetector osDetector = new OsDetector();
        if (osDetector.isWindows()) {
            LOG.debug("Identified OS type Windows");
            IS_WINDOWS = true;
            IS_MAC = false;
        } else if (osDetector.isMac()) {
            LOG.debug("Identified OS type Mac");
            IS_WINDOWS = false;
            IS_MAC = true;
        } else {
            LOG.debug("Identified OS type other. Assuming Linux or compatible.");
            IS_WINDOWS = false;
            IS_MAC = false;
        }
        LINUX_SCDAEMON_LIB_CANDIDATES = Set.of("libassuan6-0", "libassuan.so");
        LINUX_SCARD_LIB_CANDIDATES = Set.of("libpcsclite.so.1", "libpcsclite.so");
    }
}

