/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib;

import com.itemis.fluffyj.exceptions.ThrowablePrettyfier;
import com.itemis.fluffyj.memory.FluffyMemory;
import com.itemis.fluffyj.memory.api.FluffyPointer;
import com.itemis.fluffyj.memory.api.FluffyScalarPointer;
import com.itemis.fluffyj.memory.api.FluffyScalarSegment;
import com.itemis.jscdlib.internal.ScardLibNativeBridge;
import com.itemis.jscdlib.problem.JScdException;
import com.itemis.jscdlib.problem.JScdProblem;
import com.itemis.jscdlib.problem.JScdProblems;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SCardLibHandle
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(SCardLibHandle.class);
    static final MemorySegment SCARD_ALL_READERS = MemorySegment.NULL;
    static final int SCARD_AUTOALLOCATE = -1;
    static final long PCSC_SCOPE_SYSTEM = 2L;
    static final long PCSC_SCOPE_USER = 0L;
    private static final Set<JScdProblem> NON_FATAL_PROBLEMS = Set.of(JScdProblems.SCARD_S_SUCCESS, JScdProblems.SCARD_E_NO_READERS_AVAILABLE);
    private final ScardLibNativeBridge bridge;
    private final Arena myArena;

    public SCardLibHandle(ScardLibNativeBridge bridge) {
        this.bridge = Objects.requireNonNull(bridge, "bridge");
        this.myArena = Arena.ofShared();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<String> listReaders() {
        ArrayList<String> result = new ArrayList<String>();
        boolean ctxEstablished = false;
        boolean listReadersReturned = false;
        try (Arena listReadersArena = Arena.ofConfined();){
            FluffyPointer ctxPtrSeg = FluffyMemory.pointer().allocate(listReadersArena);
            FluffyScalarPointer readerListPtrSeg = FluffyMemory.pointer().of(String.class).allocate(listReadersArena);
            MemorySegment ptrToFirstEntryInReaderList = null;
            try {
                FluffyScalarSegment readerListLength = FluffyMemory.segment().of((Object)-1).allocate(listReadersArena);
                this.throwIfNoSuccess(this.bridge.sCardEstablishContext(2L, MemorySegment.NULL, MemorySegment.NULL, ctxPtrSeg.address()));
                ctxEstablished = true;
                JScdProblem listReadersProblem = this.throwIfNoSuccess(this.bridge.sCardListReaders(ctxPtrSeg.getValue(), SCARD_ALL_READERS, readerListPtrSeg.address(), readerListLength.address()));
                listReadersReturned = true;
                ptrToFirstEntryInReaderList = readerListPtrSeg.getValue();
                if (listReadersProblem != JScdProblems.SCARD_E_NO_READERS_AVAILABLE) {
                    String currentReader;
                    MemorySegment localReaderListPtrSeg = readerListPtrSeg.rawDereference();
                    Integer maxOffset = (Integer)readerListLength.getValue() - 1;
                    for (int currentOffset = 0; currentOffset < maxOffset; currentOffset += currentReader.length() + 1) {
                        currentReader = localReaderListPtrSeg.getUtf8String(currentOffset);
                        result.add(currentReader);
                    }
                }
                if (ctxEstablished) {
                    if (listReadersReturned) {
                        this.logIfNoSuccess(this.bridge.sCardFreeMemory(ctxPtrSeg.getValue(), ptrToFirstEntryInReaderList), "Possible ressource leak: Operation listReaders could not free memory.");
                    }
                    this.logIfNoSuccess(this.bridge.sCardReleaseContext(ctxPtrSeg.getValue()), "Possible ressource leak: Operation listReaders could not release scard context.");
                }
            }
            catch (Throwable throwable) {
                if (ctxEstablished) {
                    if (listReadersReturned) {
                        this.logIfNoSuccess(this.bridge.sCardFreeMemory(ctxPtrSeg.getValue(), ptrToFirstEntryInReaderList), "Possible ressource leak: Operation listReaders could not free memory.");
                    }
                    this.logIfNoSuccess(this.bridge.sCardReleaseContext(ctxPtrSeg.getValue()), "Possible ressource leak: Operation listReaders could not release scard context.");
                }
                throw throwable;
            }
        }
        return Collections.unmodifiableList(result);
    }

    private JScdProblem throwIfNoSuccess(long errorCode) {
        JScdProblem problem = JScdProblems.fromError(errorCode);
        if (!NON_FATAL_PROBLEMS.contains(problem)) {
            throw new JScdException(problem);
        }
        return problem;
    }

    private void logIfNoSuccess(long errorCode, String errMsg) {
        if (errorCode != JScdProblems.SCARD_S_SUCCESS.errorCode()) {
            JScdProblem problem = JScdProblems.fromError(errorCode);
            String logMsg = (errMsg + " Reason: %s: %s").formatted(problem, problem.description());
            LOG.warn(logMsg);
        }
    }

    private void safeClose(Arena arena) {
        try {
            arena.close();
        }
        catch (Throwable t) {
            LOG.warn("Possible ressource leak: Could not close arena. Reason: " + ThrowablePrettyfier.pretty((Throwable)t));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws Exception {
        if (!this.myArena.scope().isAlive()) {
            SCardLibHandle sCardLibHandle = this;
            synchronized (sCardLibHandle) {
                if (!this.myArena.scope().isAlive()) {
                    this.safeClose(this.myArena);
                    this.bridge.close();
                }
            }
        }
    }
}

