/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib;

import com.itemis.fluffyj.exceptions.ThrowablePrettyfier;
import com.itemis.fluffyj.memory.FluffyMemory;
import com.itemis.fluffyj.memory.api.FluffyPointer;
import com.itemis.jscdlib.discovery.JScdSocketDiscovery;
import com.itemis.jscdlib.internal.ScDaemonNativeBridge;
import com.itemis.jscdlib.problem.JScdException;
import com.itemis.jscdlib.problem.JScdProblem;
import com.itemis.jscdlib.problem.JScdProblems;
import java.lang.foreign.Arena;
import java.lang.foreign.MemorySegment;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ScDaemonHandle
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(ScDaemonHandle.class);
    static final int ASSUAN_INVALID_PID = 0;
    static final int ASSUAN_SOCKET_CONNECT_FDPASSING = 1;
    private static final Set<JScdProblem> NON_FATAL_PROBLEMS = Set.of(JScdProblems.SCARD_S_SUCCESS);
    private final FluffyPointer ctxPtr;
    private final MemorySegment ctxAddr;
    private final ScDaemonNativeBridge bridge;
    private final Arena myArena;

    public ScDaemonHandle(ScDaemonNativeBridge bridge, JScdSocketDiscovery socketDiscovery) {
        this.bridge = Objects.requireNonNull(bridge, "bridge");
        Objects.requireNonNull(socketDiscovery, "socketDiscovery");
        try {
            this.myArena = Arena.ofShared();
            this.ctxPtr = FluffyMemory.pointer().allocate(this.myArena);
            this.throwIfNoSuccess(bridge.assuanNew(this.ctxPtr.address()));
            this.ctxAddr = this.ctxPtr.getValue();
            MemorySegment socketName = FluffyMemory.segment().of((Object)socketDiscovery.discover().toString()).allocate(this.myArena).address();
            this.throwIfNoSuccess(bridge.assuanSocketConnect(this.ctxAddr, socketName, 0, 1));
        }
        catch (Throwable t) {
            this.close();
            throw t;
        }
    }

    public void sendCommand(String command, Consumer<String> responseConsumer, Consumer<String> statusConsumer) {
        TransactCallback callback = new TransactCallback(responseConsumer, statusConsumer);
        try (Arena transactArena = Arena.ofConfined();){
            MemorySegment dataCbPtr = FluffyMemory.pointer().toCFunc("data_cb").of((Object)callback).autoBindTo(transactArena);
            MemorySegment inquireCbPtr = FluffyMemory.pointer().toCFunc("inquire_cb").of((Object)callback).autoBindTo(transactArena);
            MemorySegment statusCbPtr = FluffyMemory.pointer().toCFunc("status_cb").of((Object)callback).autoBindTo(transactArena);
            MemorySegment cmdAddr = transactArena.allocateUtf8String(command);
            this.throwIfNoSuccess(this.bridge.assuanTransact(this.ctxAddr, cmdAddr, dataCbPtr, MemorySegment.NULL, inquireCbPtr, MemorySegment.NULL, statusCbPtr, MemorySegment.NULL));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.ctxAddr != null && this.myArena.scope().isAlive()) {
            ScDaemonHandle scDaemonHandle = this;
            synchronized (scDaemonHandle) {
                if (this.myArena.scope().isAlive()) {
                    try {
                        this.bridge.assuanRelease(this.ctxAddr);
                    }
                    catch (Throwable t) {
                        LOG.warn("Possible ressource leak: Operation assuanRelease could not release assuan context. Reason: " + ThrowablePrettyfier.pretty((Throwable)t));
                    }
                    finally {
                        try {
                            this.bridge.close();
                        }
                        finally {
                            this.myArena.close();
                        }
                    }
                }
            }
        }
    }

    private JScdProblem throwIfNoSuccess(long errorCode) {
        JScdProblem problem = JScdProblems.fromError(errorCode);
        if (!NON_FATAL_PROBLEMS.contains(problem)) {
            throw new JScdException(problem);
        }
        return problem;
    }

    protected static final class TransactCallback {
        private static final int SUCCESS = (int)JScdProblems.SCARD_S_SUCCESS.errorCode();
        private final Consumer<String> responseConsumer;
        private final Consumer<String> statusConsumer;

        public TransactCallback(Consumer<String> responseConsumer, Consumer<String> statusConsumer) {
            this.responseConsumer = responseConsumer;
            this.statusConsumer = statusConsumer;
        }

        public int data_cb(MemorySegment allLines, MemorySegment currentLinePtr, long lineLength) {
            this.responseConsumer.accept(this.deref(currentLinePtr));
            return SUCCESS;
        }

        public int inquire_cb(MemorySegment allLines, MemorySegment currentLinePtr) {
            return SUCCESS;
        }

        public int status_cb(MemorySegment allLines, MemorySegment currentLinePtr) {
            this.statusConsumer.accept(this.deref(currentLinePtr));
            return SUCCESS;
        }

        private String deref(MemorySegment strPtr) {
            return (String)FluffyMemory.dereference((MemorySegment)strPtr).as(String.class);
        }
    }
}

