/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib.discovery;

import com.itemis.fluffyj.exceptions.ThrowablePrettyfier;
import com.itemis.jscdlib.discovery.JScdSocketDiscovery;
import com.itemis.jscdlib.problem.JScdException;
import com.itemis.jscdlib.problem.JScdProblems;
import java.io.File;
import java.io.FileNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JScdEnvSocketDiscovery
implements JScdSocketDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(JScdEnvSocketDiscovery.class);
    public static final String JSCDLIB_SOCKET_FILE_PROP_KEY = "jscdlib.socket.file";
    public static final String GNUPGHOME_ENV_KEY = "GNUPGHOME";
    public static final String SOCKET_FILE_NAME = "S.scdaemon";

    @Override
    public Path discover() {
        Path result = null;
        LOG.debug("Trying system property 'jscdlib.socket.file'");
        Object rawResultPath = System.getProperty(JSCDLIB_SOCKET_FILE_PROP_KEY);
        if (rawResultPath == null) {
            LOG.debug("Not found. Trying environment variable 'GNUPGHOME'");
            rawResultPath = System.getenv(GNUPGHOME_ENV_KEY);
            if (rawResultPath == null) {
                LOG.error("Neither system property 'jscdlib.socket.file' nor environment variable 'GNUPGHOME' are set. Cannot determine scdaemon socket file name.");
                throw new JScdException(JScdProblems.JSCD_GENERAL_ERROR, ": Could not determine scdaemon socket file");
            }
            LOG.debug("Using value of environment variable 'GNUPGHOME' as dir of scdaemon socket file.");
            rawResultPath = (String)rawResultPath + File.separator + SOCKET_FILE_NAME;
        } else {
            LOG.debug("Found system property 'jscdlib.socket.file' set to '" + (String)rawResultPath + "'.");
        }
        try {
            result = Paths.get((String)rawResultPath, new String[0]);
            if (!Files.isRegularFile(result, new LinkOption[0])) {
                LOG.error(String.valueOf(result) + " is not a valid socket file.");
                throw new FileNotFoundException(String.valueOf(result) + " is not a valid socket file.");
            }
            LOG.debug("Found valid socket file: " + String.valueOf(result));
        }
        catch (Exception e) {
            throw new JScdException(JScdProblems.JSCD_GENERAL_ERROR, ": Converting value '" + (String)rawResultPath + "' to path caused: " + ThrowablePrettyfier.pretty((Throwable)e));
        }
        return result;
    }
}

