/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib.discovery;

import com.itemis.jscdlib.discovery.JScdSocketDiscovery;
import com.itemis.jscdlib.problem.JScdException;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JScdGpgConfSocketDiscovery
implements JScdSocketDiscovery {
    private static final Logger LOG = LoggerFactory.getLogger(JScdGpgConfSocketDiscovery.class);
    private static final String SOCKET_FILE_NAME = "S.scdaemon";
    private static final String SOCKET_DIR_LINE_PREFIX = "socketdir:";
    private final JScdSocketDiscovery fallback;

    public JScdGpgConfSocketDiscovery(JScdSocketDiscovery fallback) {
        this.fallback = Objects.requireNonNull(fallback, "fallback");
    }

    @Override
    public Path discover() {
        List<Path> socketDirCandidates = null;
        try {
            LOG.debug("Now trying to call gpgconf in order to find out scdaemon socket dir.");
            Process gpgConfProcess = new ProcessBuilder("gpgconf", "--list-dirs").start();
            try (BufferedReader output = new BufferedReader(new InputStreamReader(gpgConfProcess.getInputStream(), StandardCharsets.UTF_8));){
                socketDirCandidates = output.lines().filter(line -> line.startsWith(SOCKET_DIR_LINE_PREFIX)).map(line -> {
                    String subLine = line.substring(SOCKET_DIR_LINE_PREFIX.length());
                    String sanitizedSubLine = URLDecoder.decode(subLine, StandardCharsets.UTF_8);
                    return Paths.get(sanitizedSubLine, new String[0]);
                }).toList();
            }
            if (gpgConfProcess.isAlive()) {
                gpgConfProcess.destroyForcibly();
            }
        }
        catch (Throwable t) {
            throw new JScdException(t);
        }
        for (Path socketDirCandidate : socketDirCandidates) {
            Path socketFilePath = socketDirCandidate.resolve(SOCKET_FILE_NAME);
            LOG.debug("Identified socket file candidate: " + String.valueOf(socketFilePath));
            if (Files.isRegularFile(socketFilePath, new LinkOption[0])) {
                LOG.debug("Found valid socket file: " + String.valueOf(socketFilePath));
                return socketFilePath;
            }
            LOG.debug("Not a regular file: " + String.valueOf(socketFilePath));
        }
        return this.fallback.discover();
    }
}

