/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib.internal;

import com.itemis.fluffyj.memory.FluffyNativeMethodHandle;
import com.itemis.jscdlib.internal.NativeBase;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.util.function.Function;

public final class ScDaemonNativeBridge
extends NativeBase
implements AutoCloseable {
    private final FluffyNativeMethodHandle<Long> assuanNew;
    private final FluffyNativeMethodHandle<Long> assuanRelease;
    private final FluffyNativeMethodHandle<Long> assuanSocketConnect;
    private final FluffyNativeMethodHandle<Long> assuanTransact;
    private final Arena myArena = Arena.ofShared();

    public ScDaemonNativeBridge(Function<Arena, SymbolLookup> libSup) {
        SymbolLookup lib = libSup.apply(this.myArena);
        this.assuanNew = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("assuan_new").args(new MemoryLayout[]{ValueLayout.ADDRESS});
        this.assuanRelease = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("assuan_release").args(new MemoryLayout[]{ValueLayout.ADDRESS});
        this.assuanSocketConnect = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("assuan_socket_connect").args(new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.JAVA_INT, ValueLayout.JAVA_INT});
        this.assuanTransact = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("assuan_transact").args(new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS});
    }

    public long assuanNew(MemorySegment p_ctx) {
        return this.callNativeFunction(() -> (Long)this.assuanNew.call(new Object[]{p_ctx}));
    }

    public void assuanRelease(MemorySegment ctx) {
        this.callNativeVoidFunction(() -> this.assuanRelease.call(new Object[]{ctx}));
    }

    public long assuanSocketConnect(MemorySegment ctx, MemorySegment name, int server_pid, int flags) {
        return this.callNativeFunction(() -> (Long)this.assuanSocketConnect.call(new Object[]{ctx, name, server_pid, flags}));
    }

    public long assuanTransact(MemorySegment ctx, MemorySegment command, MemorySegment data_cb, MemorySegment data_cb_arg, MemorySegment inquire_cb, MemorySegment inquire_cb_arg, MemorySegment status_cb, MemorySegment status_cb_arg) {
        return this.callNativeFunction(() -> (Long)this.assuanTransact.call(new Object[]{ctx, command, data_cb, data_cb_arg, inquire_cb, inquire_cb_arg, status_cb, status_cb_arg}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.myArena.scope().isAlive()) {
            ScDaemonNativeBridge scDaemonNativeBridge = this;
            synchronized (scDaemonNativeBridge) {
                if (this.myArena.scope().isAlive()) {
                    this.myArena.close();
                }
            }
        }
    }
}

