/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib.internal;

import com.itemis.fluffyj.memory.FluffyNativeMethodHandle;
import com.itemis.jscdlib.internal.NativeBase;
import com.itemis.jscdlib.internal.OsDetector;
import java.lang.foreign.Arena;
import java.lang.foreign.MemoryLayout;
import java.lang.foreign.MemorySegment;
import java.lang.foreign.SymbolLookup;
import java.lang.foreign.ValueLayout;
import java.util.function.Function;

public final class ScardLibNativeBridge
extends NativeBase
implements AutoCloseable {
    private final FluffyNativeMethodHandle<Long> establishCtx;
    private final FluffyNativeMethodHandle<Long> listReaders;
    private final FluffyNativeMethodHandle<Long> freeMem;
    private final FluffyNativeMethodHandle<Long> releaseCtx;
    private final Arena myArena = Arena.ofShared();

    public ScardLibNativeBridge(Function<Arena, SymbolLookup> libSup) {
        SymbolLookup lib = libSup.apply(this.myArena);
        this.establishCtx = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("SCardEstablishContext").args(new MemoryLayout[]{ValueLayout.JAVA_LONG, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS});
        String suffix = new OsDetector().isWindows() ? "A" : "";
        this.listReaders = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("SCardListReaders" + suffix).args(new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS, ValueLayout.ADDRESS});
        this.freeMem = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("SCardFreeMemory").args(new MemoryLayout[]{ValueLayout.ADDRESS, ValueLayout.ADDRESS});
        this.releaseCtx = FluffyNativeMethodHandle.fromCLib((SymbolLookup)lib).returnType(Long.TYPE).func("SCardReleaseContext").args(new MemoryLayout[]{ValueLayout.ADDRESS});
    }

    public long sCardEstablishContext(long dwScope, MemorySegment pvReserved1, MemorySegment pvReserved2, MemorySegment phContext) {
        return this.callNativeFunction(() -> (Long)this.establishCtx.call(new Object[]{dwScope, pvReserved1, pvReserved2, phContext}));
    }

    public long sCardListReaders(MemorySegment hContext, MemorySegment mszGroups, MemorySegment mszReaders, MemorySegment pcchReaders) {
        return this.callNativeFunction(() -> (Long)this.listReaders.call(new Object[]{hContext, mszGroups, mszReaders, pcchReaders}));
    }

    public long sCardFreeMemory(MemorySegment hContext, MemorySegment pvMem) {
        return this.callNativeFunction(() -> (Long)this.freeMem.call(new Object[]{hContext, pvMem}));
    }

    public long sCardReleaseContext(MemorySegment hContext) {
        return this.callNativeFunction(() -> (Long)this.releaseCtx.call(new Object[]{hContext}));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        if (this.myArena.scope().isAlive()) {
            ScardLibNativeBridge scardLibNativeBridge = this;
            synchronized (scardLibNativeBridge) {
                if (this.myArena.scope().isAlive()) {
                    this.myArena.close();
                }
            }
        }
    }
}

