/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.jscdlib.problem;

import com.itemis.jscdlib.problem.JScdException;
import com.itemis.jscdlib.problem.JScdProblem;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public enum JScdProblems implements JScdProblem
{
    UNKNOWN_ERROR_CODE(Long.MIN_VALUE, "An operation resulted in an error code unknown to the library"),
    IMPLEMENTATION_ERROR(Long.MAX_VALUE, "Encountered an internal implementation error"),
    SCARD_S_SUCCESS(0L, "Success"),
    SCARD_E_NO_READERS_AVAILABLE(2148532270L, "Group contains no readers"),
    SCARD_E_READER_UNAVAILABLE(2148532247L, "Specified reader is not currently available for use"),
    SCARD_E_NO_MEMORY(2148532230L, "Not enough memory available to complete this command"),
    SCARD_F_INTERNAL_ERROR(2148532244L, "An internal error has been detected"),
    GPG_ERR_ASS_CONNECT_FAILED(536871171L, "Connect to assuan server failed."),
    GPG_ERR_BAD_URI(0x2000002EL, "Encountered a bad URI"),
    SCARD_E_INVALID_PARAMETER(2148532228L, "One or more of the supplied parameters could not be properly interpreted"),
    GPG_ERR_ENODEV(100696144L, "No device attached to the system"),
    GPG_ERR_ASS_UNKNOWN_CMD(100663571L, "Unknown IPC command"),
    JSCD_GENERAL_ERROR(0x90000000L, "Encountered an error");

    private final long errorCode;
    private final String description;

    private JScdProblems(long errorCode, String description) {
        this.errorCode = Objects.requireNonNull(errorCode);
        this.description = Objects.requireNonNull(description);
    }

    @Override
    public long errorCode() {
        return this.errorCode;
    }

    @Override
    public String errorName() {
        return this.name();
    }

    @Override
    public String description() {
        return this.description;
    }

    public static JScdProblem fromError(long errorCode) {
        List<JScdProblems> problemCandidates = Arrays.stream(JScdProblems.values()).filter(problem -> problem.errorCode == errorCode).toList();
        if (problemCandidates.isEmpty()) {
            throw new JScdException(UNKNOWN_ERROR_CODE, ": 0x" + Long.toHexString(errorCode).toUpperCase());
        }
        if (problemCandidates.size() > 1) {
            throw new JScdException(IMPLEMENTATION_ERROR, ": Encountered more than one problem with the same error code.");
        }
        return problemCandidates.get(0);
    }

    public String toString() {
        return this.errorName();
    }
}

