/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.aether;

import com.google.common.base.Objects;

public class ArtifactCoordinates {
    private String groupId;
    private String artifactId;
    private String version;
    private String type;
    private String classifier;

    public ArtifactCoordinates(String groupId, String artifactId, String version) {
        this(groupId, artifactId, version, null, null);
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version, String type) {
        this(groupId, artifactId, version, type, null);
    }

    public ArtifactCoordinates(String groupId, String artifactId, String version, String type, String classifier) {
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.type = type;
        this.classifier = classifier;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getArtifactId() {
        return this.artifactId;
    }

    public String getVersion() {
        return this.version;
    }

    public String getType() {
        return this.type;
    }

    public String getClassifier() {
        return this.classifier;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.groupId).append(':');
        sb.append(this.artifactId).append(':');
        if (this.type != null) {
            sb.append(this.type).append(':');
        }
        if (this.classifier != null) {
            sb.append(this.classifier).append(':');
        }
        sb.append(this.version);
        return sb.toString();
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArtifactCoordinates)) {
            return false;
        }
        return Objects.equal((Object)this.toString(), (Object)other.toString());
    }

    public boolean equalsGAV(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof ArtifactCoordinates)) {
            return false;
        }
        ArtifactCoordinates otherCoordinates = (ArtifactCoordinates)other;
        return Objects.equal((Object)this.getArtifactId(), (Object)otherCoordinates.getArtifactId()) && Objects.equal((Object)this.getGroupId(), (Object)otherCoordinates.getGroupId()) && Objects.equal((Object)this.getVersion(), (Object)otherCoordinates.getVersion());
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.groupId, this.artifactId, this.type, this.classifier, this.version});
    }
}

