/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.itemis.maven.aether.ArtifactCoordinates;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.ReleasePhase;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.project.MavenProject;
import org.codehaus.mojo.versions.api.PomHelper;
import org.w3c.dom.Document;

public abstract class AbstractVersionsStep
implements CDIMojoProcessingStep {
    @Inject
    protected Logger log;
    @Inject
    protected ReleaseMetadata metadata;
    @Inject
    @Named(value="reactorProjects")
    protected List<MavenProject> reactorProjects;
    protected Map<ArtifactCoordinates, Document> cachedPOMs;
    @Inject
    @Named(value="updateReactorDependencyVersion")
    protected boolean updateReactorDependencyVersion;
    private LoadingCache<MavenProject, Model> rawModels = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<MavenProject, Model>(){

        public Model load(MavenProject project) throws Exception {
            return PomHelper.getRawModel((MavenProject)project);
        }
    });

    protected Document loadAndProcess(MavenProject project) {
        Document document = (Document)PomUtil.parsePOM(project).get();
        this.setProjectVersion(project, document);
        this.setParentVersion(project, document);
        if (this.updateReactorDependencyVersion) {
            this.setProjectReactorDependenciesVersion(project, document);
            this.setProjectReactorDependencyManagementVersion(project, document);
            this.setProfilesReactorDependenciesVersion(project, document);
            this.setProfilesReactorDependencyManagementVersion(project, document);
        }
        return document;
    }

    private void setProjectVersion(MavenProject project, Document document) {
        Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(project.getGroupId(), project.getArtifactId());
        String oldVersion = coordinatesByPhase.get((Object)this.previousReleasePhase()).getVersion();
        String newVersion = coordinatesByPhase.get((Object)this.currentReleasePhase()).getVersion();
        this.logProjectVersionUpdate(project, oldVersion, newVersion);
        PomUtil.setProjectVersion(project.getModel(), document, newVersion);
    }

    protected void logProjectVersionUpdate(MavenProject project, String oldVersion, String newVersion) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("\tUpdate of module version '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldVersion + " => " + newVersion + "]"));
        }
    }

    private void setParentVersion(MavenProject project, Document document) {
        Parent parent = project.getModel().getParent();
        if (parent != null) {
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(parent.getGroupId(), parent.getArtifactId());
            ArtifactCoordinates oldCoordinates = coordinatesByPhase.get((Object)this.previousReleasePhase());
            ArtifactCoordinates newCoordinates = coordinatesByPhase.get((Object)this.currentReleasePhase());
            if (newCoordinates != null) {
                this.logParentVersionUpdate(project, oldCoordinates, newCoordinates);
                PomUtil.setParentVersion(project.getModel(), document, newCoordinates.getVersion());
            }
        }
    }

    protected void logParentVersionUpdate(MavenProject project, ArtifactCoordinates oldCoordinates, ArtifactCoordinates newCoordinates) {
        if (this.log.isDebugEnabled()) {
            this.log.debug((CharSequence)("\tUpdate of parent version of module '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldCoordinates.getVersion() + " => " + newCoordinates.getVersion() + "]"));
        }
    }

    private void setProjectReactorDependenciesVersion(MavenProject project, Document document) {
        String dependenciesPath = "/";
        List dependencies = ((Model)this.rawModels.getUnchecked((Object)project)).getDependencies();
        for (Dependency dependency : dependencies) {
            this.trySetDependencyVersionFromReactorProjects(project, document, "/", dependency);
        }
    }

    private void setProjectReactorDependencyManagementVersion(MavenProject project, Document document) {
        DependencyManagement dependencyManagement = ((Model)this.rawModels.getUnchecked((Object)project)).getDependencyManagement();
        if (dependencyManagement != null) {
            String dependenciesPath = "/dependencyManagement";
            List dependencies = dependencyManagement.getDependencies();
            for (Dependency dependency : dependencies) {
                this.trySetDependencyVersionFromReactorProjects(project, document, dependenciesPath, dependency);
            }
        }
    }

    private void setProfilesReactorDependenciesVersion(MavenProject project, Document document) {
        List profiles = ((Model)this.rawModels.getUnchecked((Object)project)).getProfiles();
        for (Profile profile : profiles) {
            String dependenciesPath = "/profiles/profile[id[text()='" + profile.getId() + "']]";
            List dependencies = profile.getDependencies();
            for (Dependency dependency : dependencies) {
                this.trySetDependencyVersionFromReactorProjects(project, document, dependenciesPath, dependency);
            }
        }
    }

    private void setProfilesReactorDependencyManagementVersion(MavenProject project, Document document) {
        List profiles = ((Model)this.rawModels.getUnchecked((Object)project)).getProfiles();
        for (Profile profile : profiles) {
            String dependenciesPath = "/profiles/profile[id[text()='" + profile.getId() + "']]/dependencyManagement";
            DependencyManagement dependencyManagement = profile.getDependencyManagement();
            if (dependencyManagement == null) continue;
            List dependencies = dependencyManagement.getDependencies();
            for (Dependency dependency : dependencies) {
                this.trySetDependencyVersionFromReactorProjects(project, document, dependenciesPath, dependency);
            }
        }
    }

    protected abstract ReleasePhase previousReleasePhase();

    protected abstract ReleasePhase currentReleasePhase();

    private void trySetDependencyVersionFromReactorProjects(MavenProject project, Document document, String dependenciesPath, Dependency dependency) {
        for (MavenProject reactorProject : this.reactorProjects) {
            if (!this.isReactorDependency(reactorProject, dependency)) continue;
            Map<ReleasePhase, ArtifactCoordinates> coordinatesByPhase = this.metadata.getArtifactCoordinatesByPhase(dependency.getGroupId(), dependency.getArtifactId());
            ArtifactCoordinates oldCoordinates = coordinatesByPhase.get((Object)this.previousReleasePhase());
            ArtifactCoordinates newCoordinates = coordinatesByPhase.get((Object)this.currentReleasePhase());
            if (newCoordinates == null || oldCoordinates == null || dependency.getVersion() == null || !Objects.equals(dependency.getVersion(), oldCoordinates.getVersion())) continue;
            this.log.debug((CharSequence)("\tUpdate of dependency '" + dependency.getGroupId() + ":" + dependency.getArtifactId() + "' version in '" + dependenciesPath + "' of module '" + project.getGroupId() + ":" + project.getArtifact() + "' [" + oldCoordinates.getVersion() + " => " + newCoordinates.getVersion() + "]"));
            PomUtil.setDependencyVersion(dependency, document, dependenciesPath, newCoordinates.getVersion());
        }
    }

    private boolean isReactorDependency(MavenProject project, Dependency dependency) {
        String groupId = dependency.getGroupId();
        String artifactId = dependency.getArtifactId();
        Model model = (Model)this.rawModels.getUnchecked((Object)project);
        String reactorGroupId = model.getGroupId() != null ? model.getGroupId() : model.getParent().getGroupId();
        String reactorArtifactId = model.getArtifactId();
        return Objects.equals(groupId, reactorGroupId) && Objects.equals(artifactId, reactorArtifactId);
    }
}

