/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.logging;

import com.itemis.maven.plugins.cdi.logging.Logger;
import java.text.MessageFormat;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class JavaLoggerAdapter
extends java.util.logging.Logger {
    private Logger log;

    public JavaLoggerAdapter(String name, Logger delegate) {
        super(name, null);
        this.log = delegate;
    }

    @Override
    public void log(LogRecord record) {
        if (!this.isLoggable(record.getLevel())) {
            return;
        }
        String message = record.getMessage();
        if (message != null && record.getParameters() != null) {
            MessageFormat formatter = new MessageFormat(message);
            message = formatter.format(record.getParameters());
        }
        if (this.isDebug(record.getLevel())) {
            this.log.debug((CharSequence)message, record.getThrown());
        } else if (this.isInfo(record.getLevel())) {
            this.log.info((CharSequence)message, record.getThrown());
        } else if (this.isWarn(record.getLevel())) {
            this.log.warn((CharSequence)message, record.getThrown());
        } else if (this.isError(record.getLevel())) {
            this.log.error((CharSequence)message, record.getThrown());
        }
    }

    @Override
    public void log(Level level, String msg) {
        this.log(new LogRecord(level, msg));
    }

    @Override
    public void log(Level level, String msg, Object param1) {
        LogRecord record = new LogRecord(level, msg);
        record.setParameters(new Object[]{param1});
        this.log(record);
    }

    @Override
    public void log(Level level, String msg, Object[] params) {
        LogRecord record = new LogRecord(level, msg);
        record.setParameters(params);
        this.log(record);
    }

    @Override
    public void log(Level level, String msg, Throwable thrown) {
        LogRecord record = new LogRecord(level, msg);
        record.setThrown(thrown);
        this.log(record);
    }

    @Override
    public Level getLevel() {
        if (this.log.isDebugEnabled()) {
            return Level.ALL;
        }
        if (this.log.isInfoEnabled()) {
            return Level.INFO;
        }
        if (this.log.isWarnEnabled()) {
            return Level.WARNING;
        }
        if (this.log.isErrorEnabled()) {
            return Level.SEVERE;
        }
        return Level.OFF;
    }

    @Override
    public boolean isLoggable(Level level) {
        if (this.isDebug(level) && this.log.isDebugEnabled()) {
            return true;
        }
        if (this.isInfo(level) && this.log.isInfoEnabled()) {
            return true;
        }
        if (this.isWarn(level) && this.log.isWarnEnabled()) {
            return true;
        }
        return this.isError(level) && this.log.isErrorEnabled();
    }

    private boolean isDebug(Level level) {
        return level.intValue() <= Level.CONFIG.intValue();
    }

    private boolean isInfo(Level level) {
        int value = level.intValue();
        return value <= Level.INFO.intValue() && value > Level.CONFIG.intValue();
    }

    private boolean isWarn(Level level) {
        int value = level.intValue();
        return value <= Level.WARNING.intValue() && value > Level.INFO.intValue();
    }

    private boolean isError(Level level) {
        int value = level.intValue();
        return value <= Level.SEVERE.intValue() && value > Level.WARNING.intValue();
    }
}

