/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.steps.actions;

import com.itemis.maven.aether.ArtifactDeployer;
import com.itemis.maven.plugins.cdi.CDIMojoProcessingStep;
import com.itemis.maven.plugins.cdi.ExecutionContext;
import com.itemis.maven.plugins.cdi.annotations.ProcessingStep;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.project.MavenProject;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeploymentException;

@ProcessingStep(id="deployArtifacts", description="Deploys the release artifacts to the remote repository. It is recommended to execute this step at the very last position of the workflow since it cannot be rolled back.", requiresOnline=true)
public class DeployArtifacts
implements CDIMojoProcessingStep {
    @Inject
    private Logger log;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ArtifactDeployer deployer;
    @Inject
    private ReleaseMetadata metadata;

    public void execute(ExecutionContext context) throws MojoExecutionException, MojoFailureException {
        this.log.info((CharSequence)"Deploying the release artifacts into the distribution repository");
        try {
            Collection<Artifact> deployedArtifacts = this.deployer.deployArtifacts(this.metadata.getReleaseArtifacts());
            if (!deployedArtifacts.isEmpty()) {
                this.log.debug((CharSequence)"\tDeployed the following release artifacts to the remote repository:");
                for (Artifact a : deployedArtifacts) {
                    this.log.debug((CharSequence)("\t\t" + a));
                }
            }
        }
        catch (DeploymentException e) {
            throw new MojoFailureException("Unable to deploy artifacts into remote repository.", (Throwable)e);
        }
    }
}

