/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util;

import com.google.common.base.Optional;
import com.itemis.maven.plugins.cdi.logging.Logger;
import com.itemis.maven.plugins.unleash.ReleaseMetadata;
import com.itemis.maven.plugins.unleash.scm.ScmProvider;
import com.itemis.maven.plugins.unleash.scm.merge.MergeClient;
import com.itemis.maven.plugins.unleash.scm.requests.CommitRequest;
import com.itemis.maven.plugins.unleash.util.PomUtil;
import com.itemis.maven.plugins.unleash.util.functions.FileToRelativePath;
import com.itemis.maven.plugins.unleash.util.scm.ScmPomVersionsMergeClient;
import com.itemis.maven.plugins.unleash.util.scm.ScmProviderRegistry;
import java.util.List;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DevVersionUtil {
    @Inject
    private Logger log;
    @Inject
    private MavenProject project;
    @Inject
    @Named(value="reactorProjects")
    private List<MavenProject> reactorProjects;
    @Inject
    private ReleaseMetadata metadata;
    @Inject
    @Named(value="scmMessagePrefix")
    private String scmMessagePrefix;
    @Inject
    private ScmProviderRegistry scmProviderRegistry;
    private ScmProvider scmProvider;

    @PostConstruct
    private void init() {
        this.scmProvider = this.scmProviderRegistry.getProvider();
    }

    public void revertScmSettings(MavenProject projectToRevert, Document document) {
        Scm scm = this.metadata.getCachedScmSettings(projectToRevert);
        if (scm != null) {
            this.log.debug((CharSequence)"\t\tReversion of SCM connection tags");
            Document originalPOM = this.metadata.getCachedOriginalPOM(projectToRevert);
            Node scmNode = PomUtil.getOrCreateScmNode(document, false);
            Node originalScmNode = PomUtil.getOrCreateScmNode(originalPOM, false);
            if (scmNode != null) {
                Optional<String> url;
                Optional<String> devConnection;
                Optional<String> connection = PomUtil.getChildNodeTextContent(originalScmNode, "connection");
                if (connection.isPresent()) {
                    PomUtil.setNodeTextContent(scmNode, "connection", (String)connection.get(), false);
                }
                if ((devConnection = PomUtil.getChildNodeTextContent(originalScmNode, "developerConnection")).isPresent()) {
                    PomUtil.setNodeTextContent(scmNode, "developerConnection", (String)devConnection.get(), false);
                }
                if ((url = PomUtil.getChildNodeTextContent(originalScmNode, "url")).isPresent()) {
                    PomUtil.setNodeTextContent(scmNode, "url", (String)url.get(), false);
                }
                if (scm.getTag() != null) {
                    PomUtil.setNodeTextContent(scmNode, "tag", scm.getTag(), false);
                } else {
                    PomUtil.deleteNode(scmNode, "tag");
                }
            }
        }
    }

    public void commitChanges(boolean commitPomsOnly) {
        this.log.debug((CharSequence)"\tCommitting changed POMs of all modules and pushing to remote repository. Merging with remote changes if necessary.");
        this.metadata.setScmRevisionBeforeNextDevVersion(this.scmProvider.getLatestRemoteRevision());
        StringBuilder message = new StringBuilder("Preparation for next development cycle.");
        if (StringUtils.isNotBlank((CharSequence)this.scmMessagePrefix)) {
            message.insert(0, this.scmMessagePrefix);
        }
        CommitRequest.Builder requestBuilder = CommitRequest.builder().merge().mergeClient((MergeClient)new ScmPomVersionsMergeClient()).message(message.toString()).push();
        FileToRelativePath pathConverter = new FileToRelativePath(this.project.getBasedir());
        if (commitPomsOnly) {
            for (MavenProject p : this.reactorProjects) {
                requestBuilder.addPaths(new String[]{pathConverter.apply(p.getFile())});
            }
        }
        String newRevision = this.scmProvider.commit(requestBuilder.build());
        this.metadata.setScmRevisionAfterNextDevVersion(newRevision);
    }
}

