/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.functions;

import com.google.common.base.Function;
import org.apache.maven.model.Dependency;

public enum DependencyToString implements Function<Dependency, String>
{
    INSTANCE(true),
    NO_TYPE(false);

    private boolean includeType;

    private DependencyToString(boolean includeType) {
        this.includeType = includeType;
    }

    public String apply(Dependency d) {
        StringBuilder sb = new StringBuilder(d.getGroupId());
        sb.append(":").append(d.getArtifactId());
        if (this.includeType && d.getType() != null) {
            sb.append(":").append(d.getType());
        }
        if (d.getClassifier() != null) {
            sb.append(":").append(d.getClassifier());
        }
        if (d.getVersion() != null) {
            sb.append(":").append(d.getVersion());
        }
        return sb.toString();
    }
}

