/*
 * Decompiled with CFR 0.152.
 */
package com.itemis.maven.plugins.unleash.util.functions;

import com.google.common.base.Function;
import com.itemis.maven.aether.ArtifactCoordinates;
import org.apache.maven.project.MavenProject;

public enum ProjectToCoordinates implements Function<MavenProject, ArtifactCoordinates>
{
    INSTANCE(true, null),
    EMPTY_VERSION(false, null),
    POM(true, "pom"),
    EMPTY_VERSION_POM(false, "pom");

    private boolean includeVersion;
    private String type;

    private ProjectToCoordinates(boolean version, String type) {
        this.includeVersion = version;
        this.type = type;
    }

    public ArtifactCoordinates apply(MavenProject p) {
        if (this.includeVersion) {
            return new ArtifactCoordinates(p.getGroupId(), p.getArtifactId(), p.getVersion(), this.type != null ? this.type : p.getPackaging());
        }
        return new ArtifactCoordinates(p.getGroupId(), p.getArtifactId(), "0", this.type != null ? this.type : p.getPackaging());
    }
}

