/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.asn1;

import com.itextpdf.bouncycastle.asn1.ASN1PrimitiveBC;
import com.itextpdf.bouncycastle.asn1.cms.AttributeBC;
import com.itextpdf.bouncycastle.asn1.x509.AlgorithmIdentifierBC;
import com.itextpdf.commons.bouncycastle.asn1.IASN1EncodableVector;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Primitive;
import com.itextpdf.commons.bouncycastle.asn1.cms.IAttribute;
import com.itextpdf.commons.bouncycastle.asn1.x509.IAlgorithmIdentifier;
import java.util.Objects;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;

public class ASN1EncodableVectorBC
implements IASN1EncodableVector {
    private final ASN1EncodableVector encodableVector;

    public ASN1EncodableVectorBC() {
        this.encodableVector = new ASN1EncodableVector();
    }

    public ASN1EncodableVectorBC(ASN1EncodableVector encodableVector) {
        this.encodableVector = encodableVector;
    }

    public ASN1EncodableVector getEncodableVector() {
        return this.encodableVector;
    }

    public void add(IASN1Primitive primitive) {
        ASN1PrimitiveBC primitiveBC = (ASN1PrimitiveBC)primitive;
        this.encodableVector.add((ASN1Encodable)primitiveBC.getPrimitive());
    }

    public void add(IAttribute attribute) {
        AttributeBC attributeBC = (AttributeBC)attribute;
        this.encodableVector.add((ASN1Encodable)attributeBC.getAttribute());
    }

    public void add(IAlgorithmIdentifier element) {
        AlgorithmIdentifierBC elementBc = (AlgorithmIdentifierBC)element;
        this.encodableVector.add((ASN1Encodable)elementBc.getAlgorithmIdentifier());
    }

    public void addOptional(IASN1Primitive primitive) {
        if (primitive != null) {
            this.add(primitive);
        }
    }

    public void addOptional(IAttribute attribute) {
        if (attribute != null) {
            this.add(attribute);
        }
    }

    public void addOptional(IAlgorithmIdentifier element) {
        if (element != null) {
            this.add(element);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ASN1EncodableVectorBC that = (ASN1EncodableVectorBC)o;
        return Objects.equals(this.encodableVector, that.encodableVector);
    }

    public int hashCode() {
        return Objects.hash(this.encodableVector);
    }

    public String toString() {
        return this.encodableVector.toString();
    }
}

