/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.cert;

import com.itextpdf.bouncycastle.asn1.ASN1EncodableBC;
import com.itextpdf.bouncycastle.asn1.ASN1ObjectIdentifierBC;
import com.itextpdf.bouncycastle.asn1.x500.X500NameBC;
import com.itextpdf.bouncycastle.cert.X509CRLHolderBC;
import com.itextpdf.bouncycastle.operator.ContentSignerBC;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.asn1.x500.IX500Name;
import com.itextpdf.commons.bouncycastle.cert.IX509CRLHolder;
import com.itextpdf.commons.bouncycastle.cert.IX509v2CRLBuilder;
import com.itextpdf.commons.bouncycastle.operator.IContentSigner;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.cert.X509v2CRLBuilder;

public class X509v2CRLBuilderBC
implements IX509v2CRLBuilder {
    private final X509v2CRLBuilder builder;

    public X509v2CRLBuilderBC(X509v2CRLBuilder builder) {
        this.builder = builder;
    }

    public X509v2CRLBuilderBC(IX500Name x500Name, Date date) {
        this(new X509v2CRLBuilder(((X500NameBC)x500Name).getX500Name(), date));
    }

    public X509v2CRLBuilder getBuilder() {
        return this.builder;
    }

    public IX509v2CRLBuilder addCRLEntry(BigInteger bigInteger, Date date, int i) {
        this.builder.addCRLEntry(bigInteger, date, i);
        return this;
    }

    public IX509v2CRLBuilder addExtension(IASN1ObjectIdentifier objectIdentifier, boolean isCritical, IASN1Encodable extension) throws IOException {
        this.builder.addExtension(((ASN1ObjectIdentifierBC)objectIdentifier).getASN1ObjectIdentifier(), isCritical, ((ASN1EncodableBC)extension).getEncodable());
        return this;
    }

    public IX509v2CRLBuilder setNextUpdate(Date nextUpdate) {
        this.builder.setNextUpdate(nextUpdate);
        return this;
    }

    public IX509CRLHolder build(IContentSigner signer) {
        return new X509CRLHolderBC(this.builder.build(((ContentSignerBC)signer).getContentSigner()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X509v2CRLBuilderBC that = (X509v2CRLBuilderBC)o;
        return Objects.equals(this.builder, that.builder);
    }

    public int hashCode() {
        return Objects.hash(this.builder);
    }

    public String toString() {
        return this.builder.toString();
    }
}

