/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.crypto.modes;

import com.itextpdf.commons.bouncycastle.crypto.modes.IGCMBlockCipher;
import java.util.Objects;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.modes.GCMBlockCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;

public class GCMBlockCipherBC
implements IGCMBlockCipher {
    private final GCMBlockCipher cipher;

    public GCMBlockCipherBC(GCMBlockCipher cipher) {
        this.cipher = cipher;
    }

    public GCMBlockCipher getCipher() {
        return this.cipher;
    }

    public void init(boolean forEncryption, byte[] key, int macSizeBits, byte[] iv) {
        this.cipher.init(forEncryption, (CipherParameters)new AEADParameters(new KeyParameter(key), macSizeBits, iv));
    }

    public int getUpdateOutputSize(int len) {
        return this.cipher.getUpdateOutputSize(len);
    }

    public void processBytes(byte[] input, int inputOffset, int len, byte[] output, int outOffset) {
        this.cipher.processBytes(input, inputOffset, len, output, outOffset);
    }

    public int getOutputSize(int len) {
        return this.cipher.getOutputSize(len);
    }

    public void doFinal(byte[] plainText, int i) {
        try {
            this.cipher.doFinal(plainText, i);
        }
        catch (InvalidCipherTextException e) {
            throw new IllegalArgumentException(e.getMessage(), e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GCMBlockCipherBC that = (GCMBlockCipherBC)o;
        return Objects.equals(this.cipher, that.cipher);
    }

    public int hashCode() {
        return Objects.hash(this.cipher);
    }

    public String toString() {
        return this.cipher.toString();
    }
}

