/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastle.cert.ocsp;

import com.itextpdf.bouncycastle.asn1.ASN1EncodableBC;
import com.itextpdf.bouncycastle.asn1.ASN1ObjectIdentifierBC;
import com.itextpdf.bouncycastle.cert.X509CertificateHolderBC;
import com.itextpdf.bouncycastle.cert.ocsp.OCSPExceptionBC;
import com.itextpdf.bouncycastle.cert.ocsp.RespIDBC;
import com.itextpdf.bouncycastle.cert.ocsp.SingleRespBC;
import com.itextpdf.bouncycastle.operator.ContentVerifierProviderBC;
import com.itextpdf.commons.bouncycastle.asn1.IASN1Encodable;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.cert.IX509CertificateHolder;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IBasicOCSPResp;
import com.itextpdf.commons.bouncycastle.cert.ocsp.IRespID;
import com.itextpdf.commons.bouncycastle.cert.ocsp.ISingleResp;
import com.itextpdf.commons.bouncycastle.operator.IContentVerifierProvider;
import java.io.IOException;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.SingleResp;

public class BasicOCSPRespBC
implements IBasicOCSPResp {
    private final BasicOCSPResp basicOCSPResp;

    public BasicOCSPRespBC(BasicOCSPResp basicOCSPResp) {
        this.basicOCSPResp = basicOCSPResp;
    }

    public BasicOCSPResp getBasicOCSPResp() {
        return this.basicOCSPResp;
    }

    public ISingleResp[] getResponses() {
        SingleResp[] resps = this.basicOCSPResp.getResponses();
        ISingleResp[] respsBC = new ISingleResp[resps.length];
        for (int i = 0; i < respsBC.length; ++i) {
            respsBC[i] = new SingleRespBC(resps[i]);
        }
        return respsBC;
    }

    public boolean isSignatureValid(IContentVerifierProvider provider) throws OCSPExceptionBC {
        try {
            return this.basicOCSPResp.isSignatureValid(((ContentVerifierProviderBC)provider).getContentVerifierProvider());
        }
        catch (OCSPException e) {
            throw new OCSPExceptionBC(e);
        }
    }

    public IX509CertificateHolder[] getCerts() {
        X509CertificateHolder[] certs = this.basicOCSPResp.getCerts();
        if (certs == null) {
            return new IX509CertificateHolder[0];
        }
        IX509CertificateHolder[] certsBC = new IX509CertificateHolder[certs.length];
        for (int i = 0; i < certs.length; ++i) {
            certsBC[i] = new X509CertificateHolderBC(certs[i]);
        }
        return certsBC;
    }

    public byte[] getEncoded() throws IOException {
        return this.basicOCSPResp.getEncoded();
    }

    public Date getProducedAt() {
        return this.basicOCSPResp.getProducedAt();
    }

    public IASN1Encodable getExtensionParsedValue(IASN1ObjectIdentifier objectIdentifier) {
        Extension extension = this.basicOCSPResp.getExtension(((ASN1ObjectIdentifierBC)objectIdentifier).getASN1ObjectIdentifier());
        return new ASN1EncodableBC(extension == null ? null : extension.getParsedValue());
    }

    public IRespID getResponderId() {
        return new RespIDBC(this.basicOCSPResp.getResponderId());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BasicOCSPRespBC that = (BasicOCSPRespBC)o;
        return Objects.equals(this.basicOCSPResp, that.basicOCSPResp);
    }

    public int hashCode() {
        return Objects.hash(this.basicOCSPResp);
    }

    public String toString() {
        return this.basicOCSPResp.toString();
    }
}

