/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.tsp;

import com.itextpdf.bouncycastlefips.asn1.ASN1ObjectIdentifierBCFips;
import com.itextpdf.bouncycastlefips.cert.jcajce.JcaCertStoreBCFips;
import com.itextpdf.bouncycastlefips.cms.SignerInfoGeneratorBCFips;
import com.itextpdf.bouncycastlefips.operator.DigestCalculatorBCFips;
import com.itextpdf.bouncycastlefips.tsp.TSPExceptionBCFips;
import com.itextpdf.bouncycastlefips.tsp.TimeStampRequestBCFips;
import com.itextpdf.bouncycastlefips.tsp.TimeStampTokenBCFips;
import com.itextpdf.commons.bouncycastle.asn1.IASN1ObjectIdentifier;
import com.itextpdf.commons.bouncycastle.cert.jcajce.IJcaCertStore;
import com.itextpdf.commons.bouncycastle.cms.ISignerInfoGenerator;
import com.itextpdf.commons.bouncycastle.operator.IDigestCalculator;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampRequest;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampToken;
import com.itextpdf.commons.bouncycastle.tsp.ITimeStampTokenGenerator;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.tsp.TSPException;
import org.bouncycastle.tsp.TimeStampTokenGenerator;
import org.bouncycastle.util.Store;

public class TimeStampTokenGeneratorBCFips
implements ITimeStampTokenGenerator {
    private final TimeStampTokenGenerator timeStampTokenGenerator;

    public TimeStampTokenGeneratorBCFips(TimeStampTokenGenerator timeStampTokenGenerator) {
        this.timeStampTokenGenerator = timeStampTokenGenerator;
    }

    public TimeStampTokenGeneratorBCFips(ISignerInfoGenerator siGen, IDigestCalculator dgCalc, IASN1ObjectIdentifier policy) throws TSPExceptionBCFips {
        try {
            this.timeStampTokenGenerator = new TimeStampTokenGenerator(((SignerInfoGeneratorBCFips)siGen).getSignerInfoGenerator(), ((DigestCalculatorBCFips)dgCalc).getDigestCalculator(), ((ASN1ObjectIdentifierBCFips)policy).getASN1ObjectIdentifier());
        }
        catch (TSPException e) {
            throw new TSPExceptionBCFips(e);
        }
    }

    public TimeStampTokenGenerator getTimeStampTokenGenerator() {
        return this.timeStampTokenGenerator;
    }

    public void setAccuracySeconds(int i) {
        this.timeStampTokenGenerator.setAccuracySeconds(i);
    }

    public void addCertificates(IJcaCertStore jcaCertStore) {
        this.timeStampTokenGenerator.addCertificates((Store)((JcaCertStoreBCFips)jcaCertStore).getJcaCertStore());
    }

    public ITimeStampToken generate(ITimeStampRequest request, BigInteger bigInteger, Date date) throws TSPExceptionBCFips {
        try {
            return new TimeStampTokenBCFips(this.timeStampTokenGenerator.generate(((TimeStampRequestBCFips)request).getTimeStampRequest(), bigInteger, date));
        }
        catch (TSPException e) {
            throw new TSPExceptionBCFips(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TimeStampTokenGeneratorBCFips that = (TimeStampTokenGeneratorBCFips)o;
        return Objects.equals(this.timeStampTokenGenerator, that.timeStampTokenGenerator);
    }

    public int hashCode() {
        return Objects.hash(this.timeStampTokenGenerator);
    }

    public String toString() {
        return this.timeStampTokenGenerator.toString();
    }
}

