/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.cert;

import com.itextpdf.bouncycastlefips.asn1.x500.X500NameBCFips;
import com.itextpdf.bouncycastlefips.cert.X509CRLHolderBCFips;
import com.itextpdf.bouncycastlefips.operator.ContentSignerBCFips;
import com.itextpdf.commons.bouncycastle.asn1.x500.IX500Name;
import com.itextpdf.commons.bouncycastle.cert.IX509CRLHolder;
import com.itextpdf.commons.bouncycastle.cert.IX509v2CRLBuilder;
import com.itextpdf.commons.bouncycastle.operator.IContentSigner;
import java.math.BigInteger;
import java.util.Date;
import java.util.Objects;
import org.bouncycastle.cert.X509v2CRLBuilder;

public class X509v2CRLBuilderBCFips
implements IX509v2CRLBuilder {
    private final X509v2CRLBuilder builder;

    public X509v2CRLBuilderBCFips(X509v2CRLBuilder builder) {
        this.builder = builder;
    }

    public X509v2CRLBuilderBCFips(IX500Name x500Name, Date date) {
        this(new X509v2CRLBuilder(((X500NameBCFips)x500Name).getX500Name(), date));
    }

    public X509v2CRLBuilder getBuilder() {
        return this.builder;
    }

    public IX509v2CRLBuilder addCRLEntry(BigInteger bigInteger, Date date, int i) {
        this.builder.addCRLEntry(bigInteger, date, i);
        return this;
    }

    public IX509v2CRLBuilder setNextUpdate(Date nextUpdate) {
        this.builder.setNextUpdate(nextUpdate);
        return this;
    }

    public IX509CRLHolder build(IContentSigner signer) {
        return new X509CRLHolderBCFips(this.builder.build(((ContentSignerBCFips)signer).getContentSigner()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        X509v2CRLBuilderBCFips that = (X509v2CRLBuilderBCFips)o;
        return Objects.equals(this.builder, that.builder);
    }

    public int hashCode() {
        return Objects.hash(this.builder);
    }

    public String toString() {
        return this.builder.toString();
    }
}

