/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.bouncycastlefips.openssl;

import com.itextpdf.bouncycastlefips.asn1.pcks.PrivateKeyInfoBCFips;
import com.itextpdf.bouncycastlefips.cert.X509CertificateHolderBCFips;
import com.itextpdf.bouncycastlefips.pkcs.PKCS8EncryptedPrivateKeyInfoBCFips;
import com.itextpdf.commons.bouncycastle.openssl.IPEMParser;
import java.io.IOException;
import java.util.Objects;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.pkcs.PKCS8EncryptedPrivateKeyInfo;

public class PEMParserBCFips
implements IPEMParser {
    private final PEMParser parser;

    public PEMParserBCFips(PEMParser parser) {
        this.parser = parser;
    }

    public PEMParser getParser() {
        return this.parser;
    }

    public Object readObject() throws IOException {
        Object readObject = this.parser.readObject();
        if (readObject instanceof X509CertificateHolder) {
            return new X509CertificateHolderBCFips((X509CertificateHolder)readObject);
        }
        if (readObject instanceof PKCS8EncryptedPrivateKeyInfo) {
            return new PKCS8EncryptedPrivateKeyInfoBCFips((PKCS8EncryptedPrivateKeyInfo)readObject);
        }
        if (readObject instanceof PrivateKeyInfo) {
            return new PrivateKeyInfoBCFips((PrivateKeyInfo)readObject);
        }
        return readObject;
    }

    public void close() throws IOException {
        this.parser.close();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PEMParserBCFips that = (PEMParserBCFips)o;
        return Objects.equals(this.parser, that.parser);
    }

    public int hashCode() {
        return Objects.hash(this.parser);
    }

    public String toString() {
        return this.parser.toString();
    }
}

