/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.io.source.PdfTokenizer;
import com.itextpdf.io.source.RandomAccessFileOrArray;
import com.itextpdf.io.source.RandomAccessSourceFactory;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.DeviceCmyk;
import com.itextpdf.kernel.colors.DeviceGray;
import com.itextpdf.kernel.colors.DeviceRgb;
import com.itextpdf.kernel.counter.EventCounterHandler;
import com.itextpdf.kernel.counter.event.IEvent;
import com.itextpdf.kernel.counter.event.IMetaInfo;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.font.PdfFontFactory;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfBoolean;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfRedactAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasArtifact;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.layout.Canvas;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.layout.LayoutArea;
import com.itextpdf.layout.property.TextAlignment;
import com.itextpdf.pdfcleanup.FilteredImagesCache;
import com.itextpdf.pdfcleanup.PdfCleanUpLocation;
import com.itextpdf.pdfcleanup.PdfCleanUpProcessor;
import com.itextpdf.pdfcleanup.events.PdfSweepEvent;
import java.io.IOException;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class PdfCleanUpTool {
    @Deprecated
    public static double floatMultiplier = Math.pow(10.0, 14.0);
    @Deprecated
    public static double arcTolerance = 0.0025;
    private PdfDocument pdfDocument;
    private boolean processAnnotations;
    private IMetaInfo cleanupMetaInfo;
    private Map<Integer, List<PdfCleanUpLocation>> pdfCleanUpLocations;
    private Map<PdfRedactAnnotation, List<Rectangle>> redactAnnotations;
    private FilteredImagesCache filteredImagesCache;

    public boolean isProcessAnnotations() {
        return this.processAnnotations;
    }

    public void setProcessAnnotations(boolean processAnnotations) {
        this.processAnnotations = processAnnotations;
    }

    public PdfCleanUpTool(PdfDocument pdfDocument) {
        this(pdfDocument, false);
    }

    public PdfCleanUpTool(PdfDocument pdfDocument, boolean cleanRedactAnnotations) {
        block4: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfSweep", 2, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block4;
                throw new RuntimeException(e.getCause());
            }
        }
        if (pdfDocument.getReader() == null || pdfDocument.getWriter() == null) {
            throw new PdfException("PdfDocument must be opened in stamping mode.");
        }
        this.pdfDocument = pdfDocument;
        this.pdfCleanUpLocations = new HashMap<Integer, List<PdfCleanUpLocation>>();
        this.filteredImagesCache = new FilteredImagesCache();
        if (cleanRedactAnnotations) {
            this.addCleanUpLocationsBasedOnRedactAnnotations();
        }
        this.processAnnotations = true;
    }

    public PdfCleanUpTool(PdfDocument pdfDocument, List<PdfCleanUpLocation> cleanUpLocations) {
        this(pdfDocument);
        for (PdfCleanUpLocation location : cleanUpLocations) {
            this.addCleanupLocation(location);
        }
    }

    public PdfCleanUpTool addCleanupLocation(PdfCleanUpLocation cleanUpLocation) {
        List<PdfCleanUpLocation> pgLocations = this.pdfCleanUpLocations.get(cleanUpLocation.getPage());
        if (pgLocations == null) {
            pgLocations = new ArrayList<PdfCleanUpLocation>();
            this.pdfCleanUpLocations.put(cleanUpLocation.getPage(), pgLocations);
        }
        pgLocations.add(cleanUpLocation);
        return this;
    }

    public PdfCleanUpTool setEventCountingMetaInfo(IMetaInfo metaInfo) {
        this.cleanupMetaInfo = metaInfo;
        return this;
    }

    public void cleanUp() throws IOException {
        for (Map.Entry<Integer, List<PdfCleanUpLocation>> entry : this.pdfCleanUpLocations.entrySet()) {
            this.cleanUpPage(entry.getKey(), entry.getValue());
        }
        if (this.redactAnnotations != null) {
            this.removeRedactAnnots();
        }
        this.pdfCleanUpLocations.clear();
        EventCounterHandler.getInstance().onEvent((IEvent)PdfSweepEvent.CLEANUP, this.cleanupMetaInfo, this.getClass());
    }

    private void cleanUpPage(int pageNumber, List<PdfCleanUpLocation> cleanUpLocations) {
        if (cleanUpLocations.size() == 0) {
            return;
        }
        ArrayList<Rectangle> regions = new ArrayList<Rectangle>();
        for (PdfCleanUpLocation cleanUpLocation : cleanUpLocations) {
            regions.add(cleanUpLocation.getRegion());
        }
        PdfPage page = this.pdfDocument.getPage(pageNumber);
        PdfCleanUpProcessor cleanUpProcessor = new PdfCleanUpProcessor(regions, this.pdfDocument);
        cleanUpProcessor.setFilteredImagesCache(this.filteredImagesCache);
        cleanUpProcessor.processPageContent(page);
        if (this.processAnnotations) {
            cleanUpProcessor.processPageAnnotations(page, regions, this.redactAnnotations != null);
        }
        PdfCanvas pageCleanedContents = cleanUpProcessor.popCleanedCanvas();
        page.put(PdfName.Contents, (PdfObject)pageCleanedContents.getContentStream());
        page.setResources(pageCleanedContents.getResources());
        this.colorCleanedLocations(pageCleanedContents, cleanUpLocations);
    }

    private void colorCleanedLocations(PdfCanvas canvas, List<PdfCleanUpLocation> cleanUpLocations) {
        for (PdfCleanUpLocation location : cleanUpLocations) {
            if (location.getCleanUpColor() == null) continue;
            this.addColoredRectangle(canvas, location);
        }
    }

    private void addColoredRectangle(PdfCanvas canvas, PdfCleanUpLocation location) {
        if (this.pdfDocument.isTagged()) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        canvas.saveState().setFillColor(location.getCleanUpColor()).rectangle(location.getRegion()).fill().restoreState();
        if (this.pdfDocument.isTagged()) {
            canvas.closeTag();
        }
    }

    private void addCleanUpLocationsBasedOnRedactAnnotations() {
        this.redactAnnotations = new LinkedHashMap<PdfRedactAnnotation, List<Rectangle>>();
        for (int i = 1; i <= this.pdfDocument.getNumberOfPages(); ++i) {
            this.extractLocationsFromRedactAnnotations(this.pdfDocument.getPage(i));
        }
    }

    private void extractLocationsFromRedactAnnotations(PdfPage page) {
        List annotations = page.getAnnotations();
        for (PdfAnnotation annotation : annotations) {
            if (!PdfName.Redact.equals((Object)annotation.getSubtype())) continue;
            this.extractLocationsFromSingleRedactAnnotation((PdfRedactAnnotation)annotation);
        }
    }

    private void extractLocationsFromSingleRedactAnnotation(PdfRedactAnnotation redactAnnotation) {
        List<Object> regions;
        PdfArray quadPoints = redactAnnotation.getQuadPoints();
        if (quadPoints != null && !quadPoints.isEmpty()) {
            regions = this.translateQuadPointsToRectangles(quadPoints);
        } else {
            regions = new ArrayList<Rectangle>();
            regions.add(redactAnnotation.getRectangle().toRectangle());
        }
        this.redactAnnotations.put(redactAnnotation, regions);
        int page = this.pdfDocument.getPageNumber(redactAnnotation.getPage());
        Color cleanUpColor = redactAnnotation.getInteriorColor();
        PdfStream ro = redactAnnotation.getRedactRolloverAppearance();
        if (ro != null) {
            cleanUpColor = null;
        }
        for (Rectangle rectangle : regions) {
            this.addCleanupLocation(new PdfCleanUpLocation(page, rectangle, cleanUpColor));
        }
    }

    private List<Rectangle> translateQuadPointsToRectangles(PdfArray quadPoints) {
        ArrayList<Rectangle> rectangles = new ArrayList<Rectangle>();
        for (int i = 0; i < quadPoints.size(); i += 8) {
            float x = quadPoints.getAsNumber(i + 4).floatValue();
            float y = quadPoints.getAsNumber(i + 5).floatValue();
            float width = quadPoints.getAsNumber(i + 2).floatValue() - x;
            float height = quadPoints.getAsNumber(i + 3).floatValue() - y;
            rectangles.add(new Rectangle(x, y, width, height));
        }
        return rectangles;
    }

    private void removeRedactAnnots() throws IOException {
        for (PdfRedactAnnotation annotation : this.redactAnnotations.keySet()) {
            PdfPage page = annotation.getPage();
            if (page != null) {
                page.removeAnnotation((PdfAnnotation)annotation);
                PdfPopupAnnotation popup = annotation.getPopup();
                if (popup != null) {
                    page.removeAnnotation((PdfAnnotation)popup);
                }
            }
            PdfCanvas canvas = new PdfCanvas(page);
            PdfStream redactRolloverAppearance = annotation.getRedactRolloverAppearance();
            PdfString overlayText = annotation.getOverlayText();
            Rectangle annotRect = annotation.getRectangle().toRectangle();
            if (redactRolloverAppearance != null) {
                this.drawRolloverAppearance(canvas, redactRolloverAppearance, annotRect, this.redactAnnotations.get(annotation));
                continue;
            }
            if (overlayText == null || overlayText.toUnicodeString().isEmpty()) continue;
            this.drawOverlayText(canvas, overlayText.toUnicodeString(), annotRect, annotation.getRepeat(), annotation.getDefaultAppearance(), annotation.getJustification());
        }
    }

    private void drawRolloverAppearance(PdfCanvas canvas, PdfStream redactRolloverAppearance, Rectangle annotRect, List<Rectangle> cleanedRegions) {
        if (this.pdfDocument.isTagged()) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        canvas.saveState();
        for (Rectangle rect : cleanedRegions) {
            canvas.rectangle((double)rect.getLeft(), (double)rect.getBottom(), (double)rect.getWidth(), (double)rect.getHeight());
        }
        canvas.clip().newPath();
        PdfFormXObject formXObject = new PdfFormXObject(redactRolloverAppearance);
        canvas.addXObject((PdfXObject)formXObject, 1.0f, 0.0f, 0.0f, 1.0f, annotRect.getLeft(), annotRect.getBottom());
        canvas.restoreState();
        if (this.pdfDocument.isTagged()) {
            canvas.closeTag();
        }
    }

    private void drawOverlayText(PdfCanvas canvas, String overlayText, Rectangle annotRect, PdfBoolean repeat, PdfString defaultAppearance, int justification) throws IOException {
        List fillColorArgs;
        PdfFont font;
        Map<String, List> parsedDA;
        try {
            parsedDA = this.parseDAParam(defaultAppearance);
        }
        catch (NullPointerException npe) {
            throw new PdfException("DefaultAppearance is required but not found");
        }
        float fontSize = 12.0f;
        List fontArgs = parsedDA.get("Tf");
        PdfDictionary formDictionary = ((PdfDictionary)this.pdfDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        if (fontArgs != null && formDictionary != null) {
            font = this.getFontFromAcroForm((PdfName)fontArgs.get(0));
            fontSize = ((PdfNumber)fontArgs.get(1)).floatValue();
        } else {
            font = PdfFontFactory.createFont();
        }
        if (this.pdfDocument.isTagged()) {
            canvas.openTag((CanvasTag)new CanvasArtifact());
        }
        Canvas modelCanvas = new Canvas(canvas, this.pdfDocument, annotRect, false);
        Paragraph p = (Paragraph)((Paragraph)((Paragraph)new Paragraph(overlayText).setFont(font)).setFontSize(fontSize)).setMargin(0.0f);
        TextAlignment textAlignment = TextAlignment.LEFT;
        switch (justification) {
            case 1: {
                textAlignment = TextAlignment.CENTER;
                break;
            }
            case 2: {
                textAlignment = TextAlignment.RIGHT;
                break;
            }
        }
        p.setTextAlignment(textAlignment);
        List strokeColorArgs = parsedDA.get("StrokeColor");
        if (strokeColorArgs != null) {
            p.setStrokeColor(this.getColor(strokeColorArgs));
        }
        if ((fillColorArgs = parsedDA.get("FillColor")) != null) {
            p.setFontColor(this.getColor(fillColorArgs));
        }
        modelCanvas.add((IBlockElement)p);
        if (repeat != null && repeat.getValue()) {
            Boolean isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25);
            while (isFull == null || !isFull.booleanValue()) {
                p.add(overlayText);
                LayoutArea previousArea = modelCanvas.getRenderer().getCurrentArea().clone();
                modelCanvas.relayout();
                if (modelCanvas.getRenderer().getCurrentArea().equals((Object)previousArea)) break;
                isFull = modelCanvas.getRenderer().getPropertyAsBoolean(25);
            }
        }
        modelCanvas.getRenderer().flush();
        if (this.pdfDocument.isTagged()) {
            canvas.closeTag();
        }
    }

    private Map<String, List> parseDAParam(PdfString DA) throws IOException {
        HashMap<String, List> commandArguments = new HashMap<String, List>();
        PdfTokenizer tokeniser = new PdfTokenizer(new RandomAccessFileOrArray(new RandomAccessSourceFactory().createSource(DA.toUnicodeString().getBytes(StandardCharsets.UTF_8))));
        ArrayList<Object> currentArguments = new ArrayList<Object>();
        block4: while (tokeniser.nextToken()) {
            if (tokeniser.getTokenType() == PdfTokenizer.TokenType.Other) {
                String key = tokeniser.getStringValue();
                if ("RG".equals(key) || "G".equals(key) || "K".equals(key)) {
                    key = "StrokeColor";
                } else if ("rg".equals(key) || "g".equals(key) || "k".equals(key)) {
                    key = "FillColor";
                }
                commandArguments.put(key, currentArguments);
                currentArguments = new ArrayList();
                continue;
            }
            switch (tokeniser.getTokenType()) {
                case Number: {
                    currentArguments.add(new PdfNumber((double)new Float(tokeniser.getStringValue()).floatValue()));
                    continue block4;
                }
                case Name: {
                    currentArguments.add(new PdfName(tokeniser.getStringValue()));
                    continue block4;
                }
            }
            currentArguments.add(tokeniser.getStringValue());
        }
        return commandArguments;
    }

    private PdfFont getFontFromAcroForm(PdfName fontName) {
        PdfDictionary formDictionary = ((PdfDictionary)this.pdfDocument.getCatalog().getPdfObject()).getAsDictionary(PdfName.AcroForm);
        PdfDictionary resources = formDictionary.getAsDictionary(PdfName.DR);
        PdfDictionary fonts = resources.getAsDictionary(PdfName.Font);
        return PdfFontFactory.createFont((PdfDictionary)fonts.getAsDictionary(fontName));
    }

    private Color getColor(List colorArgs) {
        DeviceGray color = null;
        switch (colorArgs.size()) {
            case 1: {
                color = new DeviceGray(((PdfNumber)colorArgs.get(0)).floatValue());
                break;
            }
            case 3: {
                color = new DeviceRgb(((PdfNumber)colorArgs.get(0)).floatValue(), ((PdfNumber)colorArgs.get(1)).floatValue(), ((PdfNumber)colorArgs.get(2)).floatValue());
                break;
            }
            case 4: {
                color = new DeviceCmyk(((PdfNumber)colorArgs.get(0)).floatValue(), ((PdfNumber)colorArgs.get(1)).floatValue(), ((PdfNumber)colorArgs.get(2)).floatValue(), ((PdfNumber)colorArgs.get(3)).floatValue());
            }
        }
        return color;
    }
}

