/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.autosweep;

import com.itextpdf.io.util.SystemUtil;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfString;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfRedactAnnotation;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.parser.PdfDocumentContentParser;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import com.itextpdf.pdfcleanup.PdfCleanUpLocation;
import com.itextpdf.pdfcleanup.PdfCleanUpTool;
import com.itextpdf.pdfcleanup.autosweep.ICleanupStrategy;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Random;

public class PdfAutoSweep {
    private ICleanupStrategy strategy;

    public PdfAutoSweep(ICleanupStrategy strategy) {
        this.strategy = strategy;
    }

    private void resetStrategy() {
        this.strategy = this.strategy.reset();
    }

    public List<PdfCleanUpLocation> getPdfCleanUpLocations(PdfPage page) {
        PdfDocument doc = page.getDocument();
        PdfDocumentContentParser parser = new PdfDocumentContentParser(doc);
        int pageNr = doc.getPageNumber(page);
        ArrayList<PdfCleanUpLocation> toClean = new ArrayList<PdfCleanUpLocation>();
        parser.processContent(pageNr, (IEventListener)this.strategy);
        for (IPdfTextLocation rect : this.strategy.getResultantLocations()) {
            if (rect == null) continue;
            toClean.add(new PdfCleanUpLocation(pageNr, rect.getRectangle(), this.strategy.getRedactionColor(rect)));
        }
        this.resetStrategy();
        return toClean;
    }

    public List<PdfCleanUpLocation> getPdfCleanUpLocations(PdfDocument doc) {
        PdfDocumentContentParser parser = new PdfDocumentContentParser(doc);
        ArrayList<PdfCleanUpLocation> toClean = new ArrayList<PdfCleanUpLocation>();
        for (int pageNr = 1; pageNr <= doc.getNumberOfPages(); ++pageNr) {
            parser.processContent(pageNr, (IEventListener)this.strategy);
            for (IPdfTextLocation rect : this.strategy.getResultantLocations()) {
                if (rect == null) continue;
                toClean.add(new PdfCleanUpLocation(pageNr, rect.getRectangle(), this.strategy.getRedactionColor(rect)));
            }
            this.resetStrategy();
        }
        Collections.sort(toClean, new Comparator<PdfCleanUpLocation>(){

            @Override
            public int compare(PdfCleanUpLocation o1, PdfCleanUpLocation o2) {
                if (o1.getPage() != o2.getPage()) {
                    return o1.getPage() < o2.getPage() ? -1 : 1;
                }
                Rectangle r1 = o1.getRegion();
                Rectangle r2 = o2.getRegion();
                if (r1.getY() == r2.getY()) {
                    return r1.getX() == r2.getX() ? 0 : (r1.getX() < r2.getX() ? -1 : 1);
                }
                return r1.getY() < r2.getY() ? -1 : 1;
            }
        });
        return toClean;
    }

    public void highlight(PdfDocument pdfDocument) {
        for (int i = 1; i <= pdfDocument.getNumberOfPages(); ++i) {
            this.highlight(pdfDocument.getPage(i));
        }
    }

    public void highlight(PdfPage pdfPage) {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfPage);
        for (PdfCleanUpLocation loc : cleanUpLocations) {
            PdfCanvas canvas = new PdfCanvas(pdfPage);
            canvas.setColor(loc.getCleanUpColor(), true);
            canvas.rectangle(loc.getRegion());
            canvas.fill();
        }
    }

    public void cleanUp(PdfDocument pdfDocument) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfDocument);
        PdfCleanUpTool cleaner = cleanUpLocations == null ? new PdfCleanUpTool(pdfDocument, true) : new PdfCleanUpTool(pdfDocument, cleanUpLocations);
        cleaner.cleanUp();
    }

    public void cleanUp(PdfPage pdfPage) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfPage);
        PdfCleanUpTool cleaner = cleanUpLocations == null ? new PdfCleanUpTool(pdfPage.getDocument(), true) : new PdfCleanUpTool(pdfPage.getDocument(), cleanUpLocations);
        cleaner.cleanUp();
    }

    public void tentativeCleanUp(PdfDocument pdfDocument) {
        for (int i = 1; i <= pdfDocument.getNumberOfPages(); ++i) {
            this.tentativeCleanUp(pdfDocument.getPage(i));
        }
    }

    public void tentativeCleanUp(PdfPage pdfPage) {
        List<PdfCleanUpLocation> cleanUpLocations = this.getPdfCleanUpLocations(pdfPage);
        Random rnd = new Random(SystemUtil.getTimeBasedIntSeed());
        HashSet usedTitles = new HashSet();
        for (PdfCleanUpLocation loc : cleanUpLocations) {
            float[] color = loc.getCleanUpColor().getColorValue();
            String title = "Annotation:" + rnd.nextInt();
            while (usedTitles.contains(title)) {
                title = "Annotation:" + rnd.nextInt();
            }
            PdfAnnotation redact = new PdfRedactAnnotation(loc.getRegion()).setDefaultAppearance(new PdfString("Helvetica 12 Tf 0 g")).setTitle(new PdfString(title)).put(PdfName.Subj, (PdfObject)PdfName.Redact).put(PdfName.IC, (PdfObject)new PdfArray(new float[]{0.0f, 0.0f, 0.0f})).put(PdfName.OC, (PdfObject)new PdfArray(color));
            pdfPage.addAnnotation(redact);
        }
    }
}

