/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.io.image.ImageData;
import com.itextpdf.io.image.ImageDataFactory;
import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.PdfException;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.BezierCurve;
import com.itextpdf.kernel.geom.IShape;
import com.itextpdf.kernel.geom.Matrix;
import com.itextpdf.kernel.geom.Path;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.geom.Subpath;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfDictionary;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfLiteral;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfNumber;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfOutputStream;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfResources;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.PdfTextArray;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLineAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfLinkAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfMarkupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfPopupAnnotation;
import com.itextpdf.kernel.pdf.annot.PdfTextMarkupAnnotation;
import com.itextpdf.kernel.pdf.canvas.CanvasGraphicsState;
import com.itextpdf.kernel.pdf.canvas.CanvasTag;
import com.itextpdf.kernel.pdf.canvas.PdfCanvas;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.PdfCanvasProcessor;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.data.ImageRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.PathRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.data.TextRenderInfo;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IEventListener;
import com.itextpdf.kernel.pdf.colorspace.PdfShading;
import com.itextpdf.kernel.pdf.tagutils.TagTreePointer;
import com.itextpdf.kernel.pdf.xobject.PdfFormXObject;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import com.itextpdf.kernel.pdf.xobject.PdfXObject;
import com.itextpdf.pdfcleanup.FilteredImagesCache;
import com.itextpdf.pdfcleanup.PdfCleanUpEventListener;
import com.itextpdf.pdfcleanup.PdfCleanUpFilter;
import com.itextpdf.pdfcleanup.TextPositioning;
import com.itextpdf.pdfcleanup.util.CleanUpCsCompareUtil;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Deque;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PdfCleanUpProcessor
extends PdfCanvasProcessor {
    private static final Set<String> TEXT_SHOWING_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("TJ", "Tj", "'", "\"")));
    private static final Set<String> PATH_CONSTRUCTION_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("m", "l", "c", "v", "y", "h", "re")));
    private static final Set<String> STROKE_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("S", "s", "B", "B*", "b", "b*")));
    private static final Set<String> NW_FILL_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("f", "F", "B", "b")));
    private static final Set<String> EO_FILL_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("f*", "B*", "b*")));
    private static final Set<String> PATH_PAINTING_OPERATORS;
    private static final Set<String> CLIPPING_PATH_OPERATORS;
    private static final Set<String> LINE_STYLE_OPERATORS;
    private static final Set<String> STROKE_COLOR_OPERATORS;
    private static final Set<String> FILL_COLOR_OPERATORS;
    private static final Set<String> TEXT_POSITIONING_OPERATORS;
    private static final Set<String> IGNORED_OPERATORS;
    private PdfDocument document;
    private PdfPage currentPage;
    private PdfCleanUpFilter filter;
    private Stack<PdfCanvas> canvasStack;
    private boolean removeAnnotIfPartOverlap = true;
    private Deque<NotAppliedGsParams> notAppliedGsParams;
    private Deque<CanvasTag> notWrittenTags;
    private int numOfOpenedTagsInsideText;
    private boolean btEncountered;
    private boolean isInText;
    private TextPositioning textPositioning;
    private FilteredImagesCache filteredImagesCache;

    PdfCleanUpProcessor(List<Rectangle> cleanUpRegions, PdfDocument document) {
        super((IEventListener)new PdfCleanUpEventListener());
        this.document = document;
        this.filter = new PdfCleanUpFilter(cleanUpRegions);
        this.canvasStack = new Stack();
        this.notAppliedGsParams = new ArrayDeque<NotAppliedGsParams>();
        this.notAppliedGsParams.push(new NotAppliedGsParams());
        this.notWrittenTags = new ArrayDeque<CanvasTag>();
        this.numOfOpenedTagsInsideText = 0;
        this.btEncountered = false;
        this.isInText = false;
        this.textPositioning = new TextPositioning();
    }

    public void processPageContent(PdfPage page) {
        this.currentPage = page;
        super.processPageContent(page);
    }

    public void processPageAnnotations(PdfPage page, List<Rectangle> regions) {
        this.processPageAnnotations(page, regions, false);
    }

    public void processPageAnnotations(PdfPage page, List<Rectangle> regions, boolean redactRedactAnnotations) {
        block0: for (PdfAnnotation annot : page.getAnnotations()) {
            PdfName annotSubtype = annot.getSubtype();
            if (PdfName.Popup.equals((Object)annotSubtype) || !redactRedactAnnotations && PdfName.Redact.equals((Object)annotSubtype)) continue;
            for (Rectangle region : regions) {
                PdfPopupAnnotation popup;
                if (!this.annotationIsToBeRedacted(annot, region)) continue;
                if (annot instanceof PdfMarkupAnnotation && (popup = ((PdfMarkupAnnotation)annot).getPopup()) != null) {
                    page.removeAnnotation((PdfAnnotation)popup);
                }
                page.removeAnnotation(annot);
                continue block0;
            }
        }
    }

    void setFilteredImagesCache(FilteredImagesCache cache) {
        this.filteredImagesCache = cache;
    }

    public void processContent(byte[] contentBytes, PdfResources resources) {
        this.canvasStack.push(new PdfCanvas(new PdfStream(), new PdfResources(), this.document));
        if (this.canvasStack.size() == 1) {
            this.getCanvas().saveState();
        }
        super.processContent(contentBytes, resources);
    }

    public IEventListener getEventListener() {
        return this.eventListener;
    }

    PdfCanvas popCleanedCanvas() {
        if (this.canvasStack.size() == 1) {
            this.getCanvas().restoreState();
        }
        return this.canvasStack.pop();
    }

    protected void invokeOperator(PdfLiteral operator, List<PdfObject> operands) {
        String operatorString = operator.toString();
        this.writeGsParamsIfFormXObject(operatorString, operands);
        super.invokeOperator(operator, operands);
        this.popCanvasIfFormXObject(operatorString, operands);
        this.filterContent(operatorString, operands);
    }

    protected void beginMarkedContent(PdfName tag, PdfDictionary dict) {
        super.beginMarkedContent(tag, dict);
        this.notWrittenTags.push(new CanvasTag(tag).setProperties(dict));
        if (this.btEncountered) {
            ++this.numOfOpenedTagsInsideText;
        }
    }

    static void writeOperands(PdfCanvas canvas, List<PdfObject> operands) {
        int index = 0;
        for (PdfObject obj : operands) {
            canvas.getContentStream().getOutputStream().write(obj);
            if (operands.size() > ++index) {
                canvas.getContentStream().getOutputStream().writeSpace();
                continue;
            }
            canvas.getContentStream().getOutputStream().writeNewLine();
        }
    }

    static Matrix operandsToMatrix(List<PdfObject> operands) {
        float a = ((PdfNumber)operands.get(0)).floatValue();
        float b = ((PdfNumber)operands.get(1)).floatValue();
        float c = ((PdfNumber)operands.get(2)).floatValue();
        float d = ((PdfNumber)operands.get(3)).floatValue();
        float e = ((PdfNumber)operands.get(4)).floatValue();
        float f = ((PdfNumber)operands.get(5)).floatValue();
        return new Matrix(a, b, c, d, e, f);
    }

    protected void eventOccurred(IEventData data, EventType type) {
        if (this.supportedEvents == null || this.supportedEvents.contains(type)) {
            this.eventListener.eventOccurred(data, type);
        }
    }

    PdfCanvas getCanvas() {
        return this.canvasStack.peek();
    }

    void addNotWrittenTag(CanvasTag tag) {
        this.notWrittenTags.push(tag);
    }

    void openNotWrittenTags() {
        CanvasTag tag = this.notWrittenTags.pollLast();
        while (tag != null) {
            this.getCanvas().openTag(tag);
            tag = this.notWrittenTags.pollLast();
        }
    }

    private boolean annotationIsToBeRedacted(PdfAnnotation annotation, Rectangle redactRegion) {
        PdfArray line;
        this.removeAnnotIfPartOverlap = true;
        PdfName annotationType = ((PdfDictionary)annotation.getPdfObject()).getAsName(PdfName.Subtype);
        if (annotationType.equals((Object)PdfName.Watermark)) {
            Logger logger = LoggerFactory.getLogger(PdfCleanUpProcessor.class);
            logger.warn("Redaction of annotation subtype /Watermark is not supported");
        }
        PdfArray rectAsArray = annotation.getRectangle();
        Rectangle rect = null;
        if (rectAsArray != null) {
            rect = rectAsArray.toRectangle();
        }
        boolean annotationIsToBeRedacted = this.processAnnotationRectangle(redactRegion, rect);
        if (PdfName.Link.equals((Object)annotationType)) {
            PdfArray quadPoints = ((PdfLinkAnnotation)annotation).getQuadPoints();
            if (this.quadPointsForLinkAnnotationAreValid(rect, quadPoints)) {
                annotationIsToBeRedacted = this.processAnnotationQuadPoints(redactRegion, quadPoints);
            }
        } else if (annotationType.equals((Object)PdfName.Highlight) || annotationType.equals((Object)PdfName.Underline) || annotationType.equals((Object)PdfName.Squiggly) || annotationType.equals((Object)PdfName.StrikeOut)) {
            PdfArray quadPoints = ((PdfTextMarkupAnnotation)annotation).getQuadPoints();
            if (quadPoints != null && annotation.getAppearanceDictionary() == null) {
                try {
                    annotationIsToBeRedacted = this.processAnnotationQuadPoints(redactRegion, quadPoints);
                }
                catch (PdfException pdfException) {}
            }
        } else if (annotationType.equals((Object)PdfName.Line) && (line = ((PdfLineAnnotation)annotation).getLine()) != null) {
            Rectangle drawnLineRectangle = line.toRectangle();
            annotationIsToBeRedacted = annotationIsToBeRedacted || this.processAnnotationRectangle(redactRegion, drawnLineRectangle);
        }
        return annotationIsToBeRedacted;
    }

    private boolean processAnnotationQuadPoints(Rectangle redactRegion, PdfArray quadPoints) {
        List boundingRectangles = Rectangle.createBoundingRectanglesFromQuadPoint((PdfArray)quadPoints);
        boolean bboxOverlapped = false;
        for (Rectangle bbox : boundingRectangles) {
            bboxOverlapped = bboxOverlapped || this.processAnnotationRectangle(redactRegion, bbox);
        }
        return bboxOverlapped;
    }

    private boolean processAnnotationRectangle(Rectangle redactRegion, Rectangle annotationRect) {
        if (annotationRect == null) {
            return false;
        }
        if (redactRegion.overlaps(annotationRect)) {
            if (redactRegion.contains(annotationRect)) {
                return true;
            }
            Rectangle intersectionRect = redactRegion.getIntersection(annotationRect);
            if (intersectionRect != null && this.removeAnnotIfPartOverlap) {
                return true;
            }
        }
        return false;
    }

    private boolean quadPointsForLinkAnnotationAreValid(Rectangle rect, PdfArray quadPoints) {
        if (quadPoints == null || quadPoints.isEmpty() || quadPoints.size() % 8 != 0) {
            return false;
        }
        for (int i = 0; i < quadPoints.size(); i += 8) {
            for (int j = 0; j < 8; j += 2) {
                PdfNumber pointX = quadPoints.getAsNumber(i + j);
                PdfNumber pointY = quadPoints.getAsNumber(i + j + 1);
                if (pointX == null || pointY == null) {
                    return false;
                }
                float x = pointX.floatValue();
                float y = pointY.floatValue();
                if (rect == null || rect.contains(new Rectangle(x, y, 0.0f, 0.0f))) continue;
                return false;
            }
        }
        return true;
    }

    private void writeGsParamsIfFormXObject(String operator, List<PdfObject> operands) {
        PdfStream formStream;
        if ("Do".equals(operator) && PdfName.Form.equals((Object)(formStream = this.getXObjectStream((PdfName)operands.get(0))).getAsName(PdfName.Subtype))) {
            this.writeNotAppliedGsParams(true, true);
            this.openNotWrittenTags();
        }
    }

    private void popCanvasIfFormXObject(String operator, List<PdfObject> operands) {
        PdfStream formStream;
        if ("Do".equals(operator) && PdfName.Form.equals((Object)(formStream = this.getXObjectStream((PdfName)operands.get(0))).getAsName(PdfName.Subtype))) {
            PdfCanvas cleanedCanvas = this.popCleanedCanvas();
            PdfFormXObject newFormXObject = new PdfFormXObject((Rectangle)null);
            ((PdfStream)newFormXObject.getPdfObject()).putAll((PdfDictionary)formStream);
            if (formStream.containsKey(PdfName.Resources)) {
                newFormXObject.put(PdfName.Resources, cleanedCanvas.getResources().getPdfObject());
            }
            ((PdfStream)newFormXObject.getPdfObject()).setData(cleanedCanvas.getContentStream().getBytes());
            PdfName name = this.getCanvas().getResources().addForm(newFormXObject);
            ((PdfOutputStream)this.getCanvas().getContentStream().getOutputStream().write((PdfObject)name).writeSpace()).writeBytes(ByteUtils.getIsoBytes((String)"Do\n"));
        }
    }

    private void filterContent(String operator, List<PdfObject> operands) {
        if (TEXT_SHOWING_OPERATORS.contains(operator)) {
            this.cleanText(operator, operands);
        } else if ("Do".equals(operator)) {
            this.checkIfImageAndClean(operands);
        } else if ("EI".equals(operator)) {
            this.cleanInlineImage();
        } else if (PATH_PAINTING_OPERATORS.contains(operator)) {
            this.writePath();
        } else if ("q".equals(operator)) {
            this.notAppliedGsParams.push(new NotAppliedGsParams());
        } else if ("Q".equals(operator)) {
            this.notAppliedGsParams.pop();
            if (this.notAppliedGsParams.size() == 0) {
                this.getCanvas().restoreState();
                this.notAppliedGsParams.push(new NotAppliedGsParams());
            }
        } else if ("BT".equals(operator)) {
            this.btEncountered = true;
        } else if ("ET".equals(operator)) {
            if (this.isInText) {
                PdfCleanUpProcessor.writeOperands(this.getCanvas(), operands);
                this.isInText = false;
            }
            this.btEncountered = false;
            this.textPositioning.clear();
        } else if (TEXT_POSITIONING_OPERATORS.contains(operator)) {
            this.textPositioning.appendPositioningOperator(operator, operands);
        } else if ("EMC".equals(operator)) {
            this.removeOrCloseTag();
        } else if (LINE_STYLE_OPERATORS.contains(operator)) {
            this.notAppliedGsParams.peek().lineStyleOperators.put(operator, new ArrayList<PdfObject>(operands));
        } else if ("gs".equals(operator)) {
            this.notAppliedGsParams.peek().extGStates.add(this.getResources().getResource(PdfName.ExtGState).getAsDictionary((PdfName)operands.get(0)));
        } else if ("cm".equals(operator)) {
            this.notAppliedGsParams.peek().ctms.add(new ArrayList<PdfObject>(operands));
        } else if (STROKE_COLOR_OPERATORS.contains(operator)) {
            this.notAppliedGsParams.peek().strokeColor = this.getGraphicsState().getStrokeColor();
        } else if (FILL_COLOR_OPERATORS.contains(operator)) {
            this.notAppliedGsParams.peek().fillColor = this.getGraphicsState().getFillColor();
        } else if ("sh".equals(operator)) {
            PdfShading shading = this.getResources().getShading((PdfName)operands.get(0));
            this.getCanvas().paintShading(shading);
        } else if (!IGNORED_OPERATORS.contains(operator)) {
            PdfCleanUpProcessor.writeOperands(this.getCanvas(), operands);
        }
    }

    private void cleanText(String operator, List<PdfObject> operands) {
        List<TextRenderInfo> textChunks = null;
        PdfArray cleanedText = null;
        if ("TJ".equals(operator)) {
            PdfArray originalTJ = (PdfArray)operands.get(0);
            if (originalTJ.isEmpty()) {
                return;
            }
            int i = 0;
            PdfTextArray newTJ = new PdfTextArray();
            for (PdfObject e : originalTJ) {
                if (e.isString()) {
                    if (null == textChunks) {
                        textChunks = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredText();
                    }
                    PdfArray filteredText = this.filter.filterText(textChunks.get(i++)).getFilterResult();
                    newTJ.addAll(filteredText);
                    continue;
                }
                newTJ.add(e);
            }
            cleanedText = newTJ;
        } else {
            textChunks = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredText();
            PdfCleanUpFilter.FilterResult<PdfArray> filterResult = this.filter.filterText(textChunks.get(0));
            if (filterResult.isModified()) {
                cleanedText = filterResult.getFilterResult();
            }
        }
        if (cleanedText == null || cleanedText.size() != 1 || !cleanedText.get(0).isNumber()) {
            if (null == textChunks) {
                textChunks = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredText();
            }
            TextRenderInfo text = textChunks.get(0);
            this.writeNotAppliedGsParamsForText(text);
            this.beginTextObjectAndOpenNotWrittenTags();
            this.writeNotAppliedTextStateParams(text);
            this.textPositioning.writePositionedText(operator, operands, cleanedText, this.getCanvas());
        } else {
            CanvasGraphicsState gs = this.getCanvas().getGraphicsState();
            if ("'".equals(operator) || "\"".equals(operator)) {
                ArrayList<PdfObject> newLineList = new ArrayList<PdfObject>();
                newLineList.add((PdfObject)new PdfLiteral("T*"));
                this.textPositioning.appendPositioningOperator("T*", newLineList);
            }
            this.textPositioning.appendTjArrayWithSingleNumber(cleanedText, gs.getFontSize(), gs.getHorizontalScaling());
        }
    }

    private void beginTextObjectAndOpenNotWrittenTags() {
        if (!this.isInText) {
            int numOfTagsBeforeBT = this.notWrittenTags.size() - this.numOfOpenedTagsInsideText;
            for (int i = 0; i < numOfTagsBeforeBT; ++i) {
                CanvasTag tag = this.notWrittenTags.pollLast();
                this.getCanvas().openTag(tag);
            }
            this.getCanvas().beginText();
            this.isInText = true;
            this.openNotWrittenTags();
        } else {
            this.openNotWrittenTags();
        }
    }

    private void writeNotAppliedTextStateParams(TextRenderInfo text) {
        PdfFont currFont;
        PdfCanvas canvas = this.getCanvas();
        CanvasGraphicsState currGs = canvas.getGraphicsState();
        if (currGs.getCharSpacing() != text.getCharSpacing()) {
            canvas.setCharacterSpacing(text.getCharSpacing());
        }
        if (currGs.getWordSpacing() != text.getWordSpacing()) {
            canvas.setWordSpacing(text.getWordSpacing());
        }
        if (currGs.getHorizontalScaling() != text.getHorizontalScaling()) {
            canvas.setHorizontalScaling(text.getHorizontalScaling());
        }
        if ((currFont = currGs.getFont()) == null || currFont.getPdfObject() != text.getFont().getPdfObject() || currGs.getFontSize() != text.getFontSize()) {
            canvas.setFontAndSize(text.getFont(), text.getFontSize());
        }
        if (currGs.getTextRenderingMode() != text.getTextRenderMode()) {
            canvas.setTextRenderingMode(text.getTextRenderMode());
        }
        if (currGs.getTextRise() != text.getRise()) {
            canvas.setTextRise(text.getRise());
        }
    }

    private void writeNotAppliedGsParamsForText(TextRenderInfo textRenderInfo) {
        boolean stroke = false;
        boolean fill = false;
        switch (textRenderInfo.getTextRenderMode()) {
            case 1: 
            case 5: {
                stroke = true;
                break;
            }
            case 0: 
            case 4: {
                fill = true;
                break;
            }
            case 2: 
            case 6: {
                stroke = true;
                fill = true;
            }
        }
        this.writeNotAppliedGsParams(fill, stroke);
    }

    private void checkIfImageAndClean(List<PdfObject> operands) {
        ImageRenderInfo encounteredImage;
        FilteredImagesCache.FilteredImageKey key;
        PdfImageXObject imageToWrite;
        PdfStream imageStream = this.getXObjectStream((PdfName)operands.get(0));
        if (PdfName.Image.equals((Object)imageStream.getAsName(PdfName.Subtype)) && (imageToWrite = this.getFilteredImage(key = this.filter.createFilteredImageKey((encounteredImage = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredImage()).getImage(), encounteredImage.getImageCtm(), this.document), encounteredImage.getImageCtm())) != null) {
            float[] ctm = this.pollNotAppliedCtm();
            this.writeNotAppliedGsParams(false, false);
            this.openNotWrittenTags();
            this.getCanvas().addXObject((PdfXObject)imageToWrite, ctm[0], ctm[1], ctm[2], ctm[3], ctm[4], ctm[5]);
        }
    }

    private PdfImageXObject getFilteredImage(FilteredImagesCache.FilteredImageKey filteredImageKey, Matrix ctmForMasksFiltering) {
        PdfImageXObject originalImage = filteredImageKey.getImageXObject();
        PdfImageXObject imageToWrite = this.getFilteredImagesCache().get(filteredImageKey);
        if (imageToWrite == null) {
            PdfCleanUpFilter.FilterResult<ImageData> imageFilterResult = this.filter.filterImage(filteredImageKey);
            if (imageFilterResult.isModified()) {
                ImageData filteredImageData = imageFilterResult.getFilterResult();
                if (Boolean.TRUE.equals(((PdfStream)originalImage.getPdfObject()).getAsBool(PdfName.ImageMask))) {
                    if (!PdfCleanUpFilter.imageSupportsDirectCleanup(originalImage)) {
                        Logger logger = LoggerFactory.getLogger(PdfCleanUpProcessor.class);
                        logger.error("Partial clean up of transparent images with mask encoded with one of the following filters is not supported: JBIG2Decode, DCTDecode, JPXDecode. Image will become non-transparent.");
                    } else {
                        filteredImageData.makeMask();
                    }
                }
                if (filteredImageData != null) {
                    PdfObject originalCS;
                    imageToWrite = new PdfImageXObject(filteredImageData);
                    this.getFilteredImagesCache().put(filteredImageKey, imageToWrite);
                    if (PdfCleanUpProcessor.areColorSpacesDifferent(originalImage, imageToWrite) && CleanUpCsCompareUtil.isOriginalCsCompatible(originalImage, imageToWrite) && (originalCS = ((PdfStream)originalImage.getPdfObject()).get(PdfName.ColorSpace)) != null) {
                        imageToWrite.put(PdfName.ColorSpace, originalCS);
                    }
                    if (ctmForMasksFiltering != null && !filteredImageData.isMask()) {
                        this.filterImageMask(originalImage, PdfName.SMask, ctmForMasksFiltering, imageToWrite);
                        this.filterImageMask(originalImage, PdfName.Mask, ctmForMasksFiltering, imageToWrite);
                        PdfArray colourKeyMaskingArr = ((PdfStream)originalImage.getPdfObject()).getAsArray(PdfName.Mask);
                        if (colourKeyMaskingArr != null) {
                            imageToWrite.put(PdfName.Mask, (PdfObject)colourKeyMaskingArr);
                        }
                        if (((PdfStream)originalImage.getPdfObject()).containsKey(PdfName.SMaskInData)) {
                            imageToWrite.put(PdfName.SMaskInData, ((PdfStream)originalImage.getPdfObject()).get(PdfName.SMaskInData));
                        }
                    }
                }
            } else {
                imageToWrite = originalImage;
            }
        }
        return imageToWrite;
    }

    private void filterImageMask(PdfImageXObject originalImage, PdfName maskKey, Matrix ctmForMasksFiltering, PdfImageXObject imageToWrite) {
        PdfStream maskStream = ((PdfStream)originalImage.getPdfObject()).getAsStream(maskKey);
        if (maskStream == null || ctmForMasksFiltering == null) {
            return;
        }
        PdfImageXObject maskImageXObject = new PdfImageXObject(maskStream);
        if (!PdfCleanUpFilter.imageSupportsDirectCleanup(maskImageXObject)) {
            Logger logger = LoggerFactory.getLogger(PdfCleanUpProcessor.class);
            logger.error("Partial clean up of transparent images with mask encoded with one of the following filters is not supported: JBIG2Decode, DCTDecode, JPXDecode. Image will become non-transparent.");
            return;
        }
        FilteredImagesCache.FilteredImageKey k = this.filter.createFilteredImageKey(maskImageXObject, ctmForMasksFiltering, this.document);
        PdfImageXObject maskToWrite = this.getFilteredImage(k, null);
        if (maskToWrite != null) {
            ((PdfStream)imageToWrite.getPdfObject()).put(maskKey, maskToWrite.getPdfObject());
        }
    }

    private FilteredImagesCache getFilteredImagesCache() {
        return this.filteredImagesCache != null ? this.filteredImagesCache : new FilteredImagesCache();
    }

    private void cleanInlineImage() {
        ImageRenderInfo encounteredImage = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredImage();
        PdfCleanUpFilter.FilterResult<ImageData> imageFilterResult = this.filter.filterImage(encounteredImage);
        ImageData filteredImage = imageFilterResult.isModified() ? imageFilterResult.getFilterResult() : ImageDataFactory.create((byte[])encounteredImage.getImage().getImageBytes());
        if (filteredImage != null) {
            Boolean imageMaskFlag = ((PdfStream)encounteredImage.getImage().getPdfObject()).getAsBool(PdfName.ImageMask);
            if (imageMaskFlag != null && imageMaskFlag.booleanValue()) {
                filteredImage.makeMask();
            }
            float[] ctm = this.pollNotAppliedCtm();
            this.writeNotAppliedGsParams(false, false);
            this.openNotWrittenTags();
            this.getCanvas().addImage(filteredImage, ctm[0], ctm[1], ctm[2], ctm[3], ctm[4], ctm[5], true);
        }
    }

    private void writePath() {
        Path strokePath;
        PathRenderInfo path = ((PdfCleanUpEventListener)this.getEventListener()).getEncounteredPath();
        boolean stroke = (path.getOperation() & 1) == 1;
        boolean fill = (path.getOperation() & 2) == 2;
        boolean clip = path.isPathModifiesClippingPath();
        Path fillPath = null;
        PdfCanvas canvas = this.getCanvas();
        if (fill && !(fillPath = this.filter.filterFillPath(path, path.getRule())).isEmpty()) {
            this.writeNotAppliedGsParams(true, false);
            this.openNotWrittenTags();
            this.writePath(fillPath);
            if (path.getRule() == 1) {
                canvas.fill();
            } else {
                canvas.eoFill();
            }
        }
        if (stroke && !(strokePath = this.filter.filterStrokePath(path)).isEmpty()) {
            this.writeNotAppliedGsParams(false, false);
            this.openNotWrittenTags();
            this.writeStrokePath(strokePath, path.getStrokeColor());
        }
        if (clip) {
            Path clippingPath = fill && path.getClippingRule() == path.getRule() ? fillPath : this.filter.filterFillPath(path, path.getClippingRule());
            if (!clippingPath.isEmpty()) {
                this.writeNotAppliedGsParams(false, false);
                this.openNotWrittenTags();
                this.writePath(clippingPath);
                if (path.getClippingRule() == 1) {
                    canvas.clip();
                } else {
                    canvas.eoClip();
                }
            } else {
                this.writeNotAppliedGsParams(false, false);
                canvas.moveTo(0.0, 0.0).clip();
            }
            canvas.newPath();
        }
    }

    private void writePath(Path path) {
        PdfCanvas canvas = this.getCanvas();
        for (Subpath subpath : path.getSubpaths()) {
            canvas.moveTo((double)((float)subpath.getStartPoint().getX()), (double)((float)subpath.getStartPoint().getY()));
            for (IShape segment : subpath.getSegments()) {
                if (segment instanceof BezierCurve) {
                    List basePoints = segment.getBasePoints();
                    Point p2 = (Point)basePoints.get(1);
                    Point p3 = (Point)basePoints.get(2);
                    Point p4 = (Point)basePoints.get(3);
                    canvas.curveTo((double)((float)p2.getX()), (double)((float)p2.getY()), (double)((float)p3.getX()), (double)((float)p3.getY()), (double)((float)p4.getX()), (double)((float)p4.getY()));
                    continue;
                }
                Point destination = (Point)segment.getBasePoints().get(1);
                canvas.lineTo((double)((float)destination.getX()), (double)((float)destination.getY()));
            }
            if (!subpath.isClosed()) continue;
            canvas.closePath();
        }
    }

    private void writeStrokePath(Path strokePath, Color strokeColor) {
        PdfCanvas canvas = this.getCanvas();
        canvas.saveState().setFillColor(strokeColor);
        this.writePath(strokePath);
        canvas.fill().restoreState();
    }

    private void removeOrCloseTag() {
        if (this.notWrittenTags.size() > 0) {
            TagTreePointer pointer;
            CanvasTag tag = this.notWrittenTags.pop();
            if (tag.hasMcid() && this.document.isTagged() && (pointer = this.document.getTagStructureContext().removeContentItem(this.currentPage, tag.getMcid())) != null) {
                while (pointer.getKidsRoles().size() == 0) {
                    pointer.removeTag();
                }
            }
        } else {
            this.getCanvas().endMarkedContent();
        }
        if (this.btEncountered) {
            --this.numOfOpenedTagsInsideText;
        }
    }

    private float[] pollNotAppliedCtm() {
        List<List<PdfObject>> ctms = this.notAppliedGsParams.peek().ctms;
        if (ctms.size() == 0) {
            return new float[]{1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f};
        }
        List<PdfObject> lastCtm = ctms.remove(ctms.size() - 1);
        float[] ctm = new float[]{((PdfNumber)lastCtm.get(0)).floatValue(), ((PdfNumber)lastCtm.get(1)).floatValue(), ((PdfNumber)lastCtm.get(2)).floatValue(), ((PdfNumber)lastCtm.get(3)).floatValue(), ((PdfNumber)lastCtm.get(4)).floatValue(), ((PdfNumber)lastCtm.get(5)).floatValue()};
        return ctm;
    }

    private void writeNotAppliedGsParams(boolean fill, boolean stroke) {
        if (this.notAppliedGsParams.size() > 0) {
            while (this.notAppliedGsParams.size() != 1) {
                NotAppliedGsParams gsParams = this.notAppliedGsParams.pollLast();
                this.applyGsParams(true, true, gsParams);
                this.getCanvas().saveState();
            }
            this.applyGsParams(fill, stroke, this.notAppliedGsParams.peek());
        }
    }

    private void applyGsParams(boolean fill, boolean stroke, NotAppliedGsParams gsParams) {
        for (PdfDictionary pdfDictionary : gsParams.extGStates) {
            this.getCanvas().setExtGState(pdfDictionary);
        }
        gsParams.extGStates.clear();
        if (gsParams.ctms.size() > 0) {
            Matrix m = new Matrix();
            for (List<PdfObject> list : gsParams.ctms) {
                m = PdfCleanUpProcessor.operandsToMatrix(list).multiply(m);
            }
            this.getCanvas().concatMatrix((double)m.get(0), (double)m.get(1), (double)m.get(3), (double)m.get(4), (double)m.get(6), (double)m.get(7));
            gsParams.ctms.clear();
        }
        if (stroke) {
            for (List list : gsParams.lineStyleOperators.values()) {
                PdfCleanUpProcessor.writeOperands(this.getCanvas(), list);
            }
            gsParams.lineStyleOperators.clear();
        }
        if (fill) {
            if (gsParams.fillColor != null) {
                this.getCanvas().setFillColor(gsParams.fillColor);
            }
            gsParams.fillColor = null;
        }
        if (stroke) {
            if (gsParams.strokeColor != null) {
                this.getCanvas().setStrokeColor(gsParams.strokeColor);
            }
            gsParams.strokeColor = null;
        }
    }

    static boolean areColorSpacesDifferent(PdfImageXObject originalImage, PdfImageXObject clearedImage) {
        PdfObject clearedImageCS;
        PdfObject originalImageCS = ((PdfStream)originalImage.getPdfObject()).get(PdfName.ColorSpace);
        if (originalImageCS == (clearedImageCS = ((PdfStream)clearedImage.getPdfObject()).get(PdfName.ColorSpace))) {
            return false;
        }
        if (originalImageCS == null || clearedImageCS == null) {
            return true;
        }
        if (originalImageCS.equals(clearedImageCS)) {
            return false;
        }
        if (originalImageCS.isArray() && clearedImageCS.isArray()) {
            PdfArray originalCSArray = (PdfArray)originalImageCS;
            PdfArray clearedCSArray = (PdfArray)clearedImageCS;
            if (originalCSArray.size() != clearedCSArray.size()) {
                return true;
            }
            for (int i = 0; i < originalCSArray.size(); ++i) {
                PdfObject objectFromCleared;
                PdfObject objectFromOriginal = originalCSArray.get(i);
                if (objectFromOriginal.equals(objectFromCleared = clearedCSArray.get(i))) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    static {
        CLIPPING_PATH_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("W", "W*")));
        LINE_STYLE_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("w", "J", "j", "M", "d")));
        STROKE_COLOR_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("CS", "SC", "SCN", "G", "RG", "K")));
        FILL_COLOR_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("cs", "sc", "scn", "g", "rg", "k")));
        TEXT_POSITIONING_OPERATORS = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("Td", "TD", "Tm", "T*", "TL")));
        HashSet<String> tempSet = new HashSet<String>();
        tempSet.addAll(STROKE_OPERATORS);
        tempSet.addAll(NW_FILL_OPERATORS);
        tempSet.addAll(EO_FILL_OPERATORS);
        tempSet.add("n");
        PATH_PAINTING_OPERATORS = Collections.unmodifiableSet(tempSet);
        tempSet = new HashSet();
        tempSet.addAll(PATH_CONSTRUCTION_OPERATORS);
        tempSet.addAll(CLIPPING_PATH_OPERATORS);
        tempSet.addAll(LINE_STYLE_OPERATORS);
        tempSet.addAll(Arrays.asList("Tc", "Tw", "Tz", "Tf", "Tr", "Ts"));
        tempSet.addAll(Arrays.asList("BMC", "BDC"));
        IGNORED_OPERATORS = Collections.unmodifiableSet(tempSet);
    }

    static class NotAppliedGsParams {
        List<PdfDictionary> extGStates = new ArrayList<PdfDictionary>();
        List<List<PdfObject>> ctms = new ArrayList<List<PdfObject>>();
        Color fillColor;
        Color strokeColor;
        Map<String, List<PdfObject>> lineStyleOperators = new LinkedHashMap<String, List<PdfObject>>();

        NotAppliedGsParams() {
        }
    }
}

