/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.util;

import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.kernel.pdf.PdfObject;
import com.itextpdf.kernel.pdf.PdfStream;
import com.itextpdf.kernel.pdf.xobject.PdfImageXObject;
import java.io.IOException;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.Imaging;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class CleanUpCsCompareUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(CleanUpCsCompareUtil.class);

    private CleanUpCsCompareUtil() {
    }

    public static boolean isOriginalCsCompatible(PdfImageXObject originalImage, PdfImageXObject clearedImage) {
        try {
            ImageInfo cmpInfo = Imaging.getImageInfo((byte[])originalImage.getImageBytes());
            ImageInfo toCompareInfo = Imaging.getImageInfo((byte[])clearedImage.getImageBytes());
            return cmpInfo.getColorType() == toCompareInfo.getColorType() && cmpInfo.isTransparent() == toCompareInfo.isTransparent() && cmpInfo.getBitsPerPixel() == toCompareInfo.getBitsPerPixel() || CleanUpCsCompareUtil.isCSApplicable(originalImage, toCompareInfo);
        }
        catch (IOException | ImageReadException e) {
            if (LOGGER.isErrorEnabled()) {
                LOGGER.error("Cannot obtain image info after filtering.", e);
            }
            return false;
        }
    }

    private static boolean isCSApplicable(PdfImageXObject originalImage, ImageInfo clearedImageInfo) {
        PdfObject pdfColorSpace = ((PdfStream)originalImage.getPdfObject()).get(PdfName.ColorSpace);
        PdfName name = pdfColorSpace.isArray() ? ((PdfArray)pdfColorSpace).getAsName(0) : (pdfColorSpace.isName() ? (PdfName)pdfColorSpace : new PdfName(""));
        if (PdfName.Separation.equals((Object)name) || PdfName.DeviceGray.equals((Object)name)) {
            return clearedImageInfo.getBitsPerPixel() == 8 && clearedImageInfo.getColorType() == ImageInfo.ColorType.GRAYSCALE;
        }
        return false;
    }
}

