/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.commons.actions.contexts.IMetaInfo;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.kernel.pdf.PdfReader;
import com.itextpdf.kernel.pdf.PdfWriter;
import com.itextpdf.kernel.pdf.StampingProperties;
import com.itextpdf.pdfcleanup.CleanUpProperties;
import com.itextpdf.pdfcleanup.PdfCleanUpLocation;
import com.itextpdf.pdfcleanup.PdfCleanUpTool;
import com.itextpdf.pdfcleanup.autosweep.ICleanupStrategy;
import com.itextpdf.pdfcleanup.autosweep.PdfAutoSweepTools;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Collections;
import java.util.List;

public final class PdfCleaner {
    private PdfCleaner() {
    }

    public static void cleanUp(InputStream inputPdf, OutputStream outputPdf, List<PdfCleanUpLocation> cleanUpLocations) throws IOException {
        PdfCleaner.cleanUp(inputPdf, outputPdf, cleanUpLocations, new CleanUpProperties());
    }

    public static void cleanUp(InputStream inputPdf, OutputStream outputPdf, List<PdfCleanUpLocation> cleanUpLocations, CleanUpProperties properties) throws IOException {
        StampingProperties stampingProperties = new StampingProperties();
        IMetaInfo propertiesMetaInfo = properties.getMetaInfo();
        stampingProperties.setEventCountingMetaInfo((IMetaInfo)(propertiesMetaInfo == null ? new CleanUpToolMetaInfo() : propertiesMetaInfo));
        try (PdfReader reader = new PdfReader(inputPdf);
             PdfWriter writer = new PdfWriter(outputPdf);
             PdfDocument pdfDocument = new PdfDocument(reader, writer, stampingProperties);){
            PdfCleaner.cleanUp(pdfDocument, cleanUpLocations, properties);
        }
    }

    public static void cleanUp(PdfDocument pdfDocument, List<PdfCleanUpLocation> cleanUpLocations) throws IOException {
        PdfCleaner.cleanUp(pdfDocument, cleanUpLocations, new CleanUpProperties());
    }

    public static void cleanUp(PdfDocument pdfDocument, List<PdfCleanUpLocation> cleanUpLocations, CleanUpProperties properties) throws IOException {
        PdfCleanUpTool cleanUpTool = new PdfCleanUpTool(pdfDocument, cleanUpLocations, properties);
        cleanUpTool.cleanUp();
    }

    public static void autoSweepCleanUp(InputStream inputPdf, OutputStream outputPdf, ICleanupStrategy strategy) throws IOException {
        PdfCleaner.autoSweepCleanUp(inputPdf, outputPdf, strategy, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(InputStream inputPdf, OutputStream outputPdf, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations) throws IOException {
        PdfCleaner.autoSweepCleanUp(inputPdf, outputPdf, strategy, additionalCleanUpLocations, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(InputStream inputPdf, OutputStream outputPdf, ICleanupStrategy strategy, CleanUpProperties properties) throws IOException {
        PdfCleaner.autoSweepCleanUp(inputPdf, outputPdf, strategy, Collections.emptyList(), properties);
    }

    public static void autoSweepCleanUp(InputStream inputPdf, OutputStream outputPdf, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations, CleanUpProperties properties) throws IOException {
        StampingProperties stampingProperties = new StampingProperties();
        IMetaInfo propertiesMetaInfo = properties.getMetaInfo();
        stampingProperties.setEventCountingMetaInfo((IMetaInfo)(propertiesMetaInfo == null ? new CleanUpToolMetaInfo() : propertiesMetaInfo));
        try (PdfReader reader = new PdfReader(inputPdf);
             PdfWriter writer = new PdfWriter(outputPdf);
             PdfDocument pdfDocument = new PdfDocument(reader, writer, stampingProperties);){
            PdfCleaner.autoSweepCleanUp(pdfDocument, strategy, additionalCleanUpLocations, properties);
        }
    }

    public static void autoSweepCleanUp(PdfDocument pdfDocument, ICleanupStrategy strategy) throws IOException {
        PdfCleaner.autoSweepCleanUp(pdfDocument, strategy, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(PdfDocument pdfDocument, ICleanupStrategy strategy, CleanUpProperties properties) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfDocument);
        PdfCleaner.cleanUp(pdfDocument, cleanUpLocations, properties);
    }

    public static void autoSweepCleanUp(PdfDocument pdfDocument, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfDocument);
        cleanUpLocations.addAll(additionalCleanUpLocations);
        PdfCleaner.cleanUp(pdfDocument, cleanUpLocations, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(PdfDocument pdfDocument, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations, CleanUpProperties properties) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfDocument);
        cleanUpLocations.addAll(additionalCleanUpLocations);
        PdfCleaner.cleanUp(pdfDocument, cleanUpLocations, properties);
    }

    public static void autoSweepCleanUp(PdfPage pdfPage, ICleanupStrategy strategy) throws IOException {
        PdfCleaner.autoSweepCleanUp(pdfPage, strategy, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(PdfPage pdfPage, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfPage);
        cleanUpLocations.addAll(additionalCleanUpLocations);
        PdfCleaner.cleanUp(pdfPage.getDocument(), cleanUpLocations, new CleanUpProperties());
    }

    public static void autoSweepCleanUp(PdfPage pdfPage, ICleanupStrategy strategy, CleanUpProperties properties) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfPage);
        PdfCleaner.cleanUp(pdfPage.getDocument(), cleanUpLocations, properties);
    }

    public static void autoSweepCleanUp(PdfPage pdfPage, ICleanupStrategy strategy, List<PdfCleanUpLocation> additionalCleanUpLocations, CleanUpProperties properties) throws IOException {
        List<PdfCleanUpLocation> cleanUpLocations = new PdfAutoSweepTools(strategy).getPdfCleanUpLocations(pdfPage);
        cleanUpLocations.addAll(additionalCleanUpLocations);
        PdfCleaner.cleanUp(pdfPage.getDocument(), cleanUpLocations, properties);
    }

    public static void cleanUpRedactAnnotations(InputStream inputPdf, OutputStream outputPdf) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(inputPdf, outputPdf, new CleanUpProperties());
    }

    public static void cleanUpRedactAnnotations(InputStream inputPdf, OutputStream outputPdf, CleanUpProperties properties) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(inputPdf, outputPdf, null, properties);
    }

    public static void cleanUpRedactAnnotations(PdfDocument pdfDocument) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(pdfDocument, null, new CleanUpProperties());
    }

    public static void cleanUpRedactAnnotations(PdfDocument pdfDocument, CleanUpProperties properties) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(pdfDocument, null, properties);
    }

    public static void cleanUpRedactAnnotations(InputStream inputPdf, OutputStream outputPdf, List<PdfCleanUpLocation> additionalCleanUpLocations) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(inputPdf, outputPdf, additionalCleanUpLocations, new CleanUpProperties());
    }

    public static void cleanUpRedactAnnotations(PdfDocument pdfDocument, List<PdfCleanUpLocation> additionalCleanUpLocations) throws IOException {
        PdfCleaner.cleanUpRedactAnnotations(pdfDocument, additionalCleanUpLocations, new CleanUpProperties());
    }

    public static void cleanUpRedactAnnotations(InputStream inputPdf, OutputStream outputPdf, List<PdfCleanUpLocation> additionalCleanUpLocations, CleanUpProperties properties) throws IOException {
        StampingProperties stampingProperties = new StampingProperties();
        IMetaInfo propertiesMetaInfo = properties.getMetaInfo();
        stampingProperties.setEventCountingMetaInfo((IMetaInfo)(propertiesMetaInfo == null ? new CleanUpToolMetaInfo() : propertiesMetaInfo));
        try (PdfReader reader = new PdfReader(inputPdf);
             PdfWriter writer = new PdfWriter(outputPdf);
             PdfDocument pdfDocument = new PdfDocument(reader, writer, stampingProperties);){
            PdfCleaner.cleanUpRedactAnnotations(pdfDocument, additionalCleanUpLocations, properties);
        }
    }

    public static void cleanUpRedactAnnotations(PdfDocument pdfDocument, List<PdfCleanUpLocation> additionalCleanUpLocations, CleanUpProperties properties) throws IOException {
        PdfCleanUpTool cleanUpTool = new PdfCleanUpTool(pdfDocument, true, properties);
        if (additionalCleanUpLocations != null) {
            for (PdfCleanUpLocation cleanUpLocation : additionalCleanUpLocations) {
                cleanUpTool.addCleanupLocation(cleanUpLocation);
            }
        }
        cleanUpTool.cleanUp();
    }

    static class CleanUpToolMetaInfo
    implements IMetaInfo {
        CleanUpToolMetaInfo() {
        }
    }
}

