/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.autosweep;

import java.util.regex.Pattern;

public class CommonRegex {
    public static Pattern MODERN_ROMAN_NUMERALS_STRICT = Pattern.compile("(?=[MDCLXVI])M*(C[MD]|D?C{0,3})(X[CL]|L?X{0,3})(I[XV]|V?I{0,3})");
    public static Pattern MODERN_ROMAN_NUMERALS_FLEXIBLE = Pattern.compile("(?=[MDCLXVI])M*(C[MD]|D?C*)(X[CL]|L?X*)(I[XV]|V?I*)");
    public static Pattern US_SOCIAL_SECURITY_NUMBER = Pattern.compile("\\d{3}-\\d{2}-\\d{4}");
    public static Pattern US_ZIP_CODE = Pattern.compile("\\d{5}(-\\d{4})?");
    public static Pattern US_CURRENCY = Pattern.compile("\\$(\\d{1,3}(\\,\\d{3})*|(\\d+))(\\.\\d{2})?");
    public static Pattern CANADA_SOCIAL_SECURITY_NUMBER = Pattern.compile("\\d{3}-\\d{3}-\\d{3}");
    public static Pattern CANADA_ZIP_CODE = Pattern.compile("(?!.*[DFIOQU])[A-VXY][0-9][A-Z] ?[0-9][A-Z][0-9]");
    public static Pattern UK_SOCIAL_SECURITY_NUMBER = Pattern.compile("[A-Z]{2}\\d{6}[A-Z]]");
    public static Pattern UK_ZIP_CODE = Pattern.compile("[A-Z]{1,2}[0-9R][0-9A-Z]? [0-9][ABD-HJLNP-UW-Z]{2}");
    public static Pattern UK_CURRENCY = Pattern.compile("\u00a3(\\d{1,3}(\\,\\d{3})*|(\\d+))(\\.\\d{2})?");
    public static Pattern EU_CURRENCY = Pattern.compile("\u20ac(\\d{1,3}(\\,\\d{3})*|(\\d+))(\\.\\d{2})?");
    public static Pattern DATE_MM_DD_YYYY = Pattern.compile("\\d{1,2}[ \\/-]\\d{1,2}[ \\/-]\\d{4}");
    public static Pattern DATE_MM_DD_YYYY_HH_MM_SS = Pattern.compile("\\d{1,2}[ \\/-]\\d{1,2}[ \\/-]\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}");
    public static Pattern DATE_DD_MM_YYYY = Pattern.compile("\\d{1,2}[ \\/-]\\d{1,2}[ \\/-]\\d{4}");
    public static Pattern DATE_DD_MM_YYYY_HH_MM_SS = Pattern.compile("\\d{1,2}[ \\/-]\\d{1,2}[ \\/-]\\d{4} \\d{1,2}:\\d{1,2}:\\d{1,2}");
    public static Pattern IPV4_ADDRESS = Pattern.compile("(?:[0-9]{1,3}\\.){3}[0-9]{1,3}");
    public static Pattern IPV6_ADDRESS = Pattern.compile("(?:[a-fA-F0-9]{1,4}:){7}[a-fA-F0-9]{1,4}");
    public static Pattern MAC_ADDRESS = Pattern.compile("([0-9a-fA-F][0-9a-fA-F]:){5}([0-9a-fA-F][0-9a-fA-F])");
    public static Pattern EMAIL_ADDRESS = Pattern.compile("[0-9a-zA-Z]([-.\\w]*[0-9a-zA-Z])*@([0-9a-zA-Z][-\\w]*[0-9a-zA-Z]\\.)+[a-zA-Z]{2,9}");
    public static Pattern HTTP_URL = Pattern.compile("(https?|ftp)://[a-z0-9-]+(\\.[a-z0-9-]+)+([/?].+)?");
}

