/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.autosweep;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.canvas.parser.EventType;
import com.itextpdf.kernel.pdf.canvas.parser.data.IEventData;
import com.itextpdf.kernel.pdf.canvas.parser.listener.ILocationExtractionStrategy;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import com.itextpdf.pdfcleanup.autosweep.ICleanupStrategy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CompositeCleanupStrategy
implements ICleanupStrategy {
    private Map<Integer, Set<IPdfTextLocation>> locations = new HashMap<Integer, Set<IPdfTextLocation>>();
    private List<ICleanupStrategy> strategies = new ArrayList<ICleanupStrategy>();

    public void add(ICleanupStrategy strategy) {
        this.strategies.add(strategy);
    }

    public Collection<IPdfTextLocation> getResultantLocations() {
        this.locations.clear();
        LinkedHashSet retval = new LinkedHashSet();
        for (int i = 0; i < this.strategies.size(); ++i) {
            ILocationExtractionStrategy s = this.strategies.get(i);
            Collection rects = s.getResultantLocations();
            retval.addAll(rects);
            this.locations.put(i, new HashSet(rects));
        }
        ArrayList<IPdfTextLocation> rectangles = new ArrayList<IPdfTextLocation>(retval);
        Collections.sort(rectangles, new Comparator<IPdfTextLocation>(){

            @Override
            public int compare(IPdfTextLocation l1, IPdfTextLocation l2) {
                Rectangle r1 = l1.getRectangle();
                Rectangle r2 = l2.getRectangle();
                if (r1.getY() == r2.getY()) {
                    return r1.getX() == r2.getX() ? 0 : (r1.getX() < r2.getX() ? -1 : 1);
                }
                return r1.getY() < r2.getY() ? -1 : 1;
            }
        });
        return rectangles;
    }

    @Override
    public Color getRedactionColor(IPdfTextLocation location) {
        for (int i = 0; i < this.strategies.size(); ++i) {
            if (!this.locations.get(i).contains(location)) continue;
            return this.strategies.get(i).getRedactionColor(location);
        }
        return ColorConstants.BLACK;
    }

    public void eventOccurred(IEventData data, EventType type) {
        for (ILocationExtractionStrategy iLocationExtractionStrategy : this.strategies) {
            iLocationExtractionStrategy.eventOccurred(data, type);
        }
    }

    public Set<EventType> getSupportedEvents() {
        HashSet<EventType> evts = new HashSet<EventType>();
        for (ILocationExtractionStrategy iLocationExtractionStrategy : this.strategies) {
            Set se = iLocationExtractionStrategy.getSupportedEvents();
            if (se == null) continue;
            evts.addAll(se);
        }
        return evts.isEmpty() ? null : evts;
    }

    @Override
    public ICleanupStrategy reset() {
        CompositeCleanupStrategy resetCompositeStrategy = new CompositeCleanupStrategy();
        for (ICleanupStrategy s : this.strategies) {
            resetCompositeStrategy.add(s.reset());
        }
        return resetCompositeStrategy;
    }
}

