/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.autosweep;

import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.colors.ColorConstants;
import com.itextpdf.kernel.pdf.canvas.parser.listener.IPdfTextLocation;
import com.itextpdf.kernel.pdf.canvas.parser.listener.RegexBasedLocationExtractionStrategy;
import com.itextpdf.pdfcleanup.autosweep.ICleanupStrategy;
import java.util.regex.Pattern;

public class RegexBasedCleanupStrategy
extends RegexBasedLocationExtractionStrategy
implements ICleanupStrategy {
    private Pattern pattern;
    private Color redactionColor = ColorConstants.BLACK;

    public RegexBasedCleanupStrategy(String regex) {
        super(regex);
        this.pattern = Pattern.compile(regex);
    }

    public RegexBasedCleanupStrategy(Pattern pattern) {
        super(pattern);
        this.pattern = pattern;
    }

    @Override
    public Color getRedactionColor(IPdfTextLocation location) {
        return this.redactionColor;
    }

    public RegexBasedCleanupStrategy setRedactionColor(Color color) {
        this.redactionColor = color;
        return this;
    }

    @Override
    public ICleanupStrategy reset() {
        return new RegexBasedCleanupStrategy(this.pattern).setRedactionColor(this.redactionColor);
    }
}

