/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup;

import com.itextpdf.kernel.geom.Path;
import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Subpath;
import com.itextpdf.kernel.pdf.PdfArray;
import java.util.HashSet;
import java.util.List;

public class LineDashPattern {
    private PdfArray dashArray;
    private float dashPhase;
    private int currentIndex;
    private int elemOrdinalNumber = 1;
    private DashArrayElem currentElem;

    public LineDashPattern(PdfArray dashArray, float dashPhase) {
        this.dashArray = new PdfArray(dashArray);
        this.dashPhase = dashPhase;
        this.initFirst(dashPhase);
    }

    public PdfArray getDashArray() {
        return this.dashArray;
    }

    public void setDashArray(PdfArray dashArray) {
        this.dashArray = dashArray;
    }

    public float getDashPhase() {
        return this.dashPhase;
    }

    public void setDashPhase(float dashPhase) {
        this.dashPhase = dashPhase;
    }

    private DashArrayElem next() {
        DashArrayElem ret = this.currentElem;
        if (this.dashArray.size() > 0) {
            this.currentIndex = (this.currentIndex + 1) % this.dashArray.size();
            this.currentElem = new DashArrayElem(this.dashArray.getAsNumber(this.currentIndex).floatValue(), this.isEven(++this.elemOrdinalNumber));
        }
        return ret;
    }

    private void reset() {
        this.currentIndex = 0;
        this.elemOrdinalNumber = 1;
        this.initFirst(this.dashPhase);
    }

    public boolean isSolid() {
        if (this.dashArray.size() % 2 != 0) {
            return false;
        }
        float unitsOffSum = 0.0f;
        for (int i = 1; i < this.dashArray.size(); i += 2) {
            unitsOffSum += this.dashArray.getAsNumber(i).floatValue();
        }
        return Float.compare(unitsOffSum, 0.0f) == 0;
    }

    private void initFirst(float phase) {
        if (this.dashArray.size() > 0) {
            while (phase > 0.0f) {
                phase -= this.dashArray.getAsNumber(this.currentIndex).floatValue();
                this.currentIndex = (this.currentIndex + 1) % this.dashArray.size();
                ++this.elemOrdinalNumber;
            }
            if (phase < 0.0f) {
                --this.elemOrdinalNumber;
                --this.currentIndex;
                this.currentElem = new DashArrayElem(-phase, this.isEven(this.elemOrdinalNumber));
            } else {
                this.currentElem = new DashArrayElem(this.dashArray.getAsNumber(this.currentIndex).floatValue(), this.isEven(this.elemOrdinalNumber));
            }
        }
    }

    private boolean isEven(int num) {
        return num % 2 == 0;
    }

    public static Path applyDashPattern(Path path, LineDashPattern lineDashPattern) {
        HashSet modifiedSubpaths = new HashSet(path.replaceCloseWithLine());
        Path dashedPath = new Path();
        int currentSubpath = 0;
        for (Subpath subpath : path.getSubpaths()) {
            List subpathApprox = subpath.getPiecewiseLinearApproximation();
            if (subpathApprox.size() > 1) {
                Point nextPoint;
                dashedPath.moveTo((float)((Point)subpathApprox.get(0)).getX(), (float)((Point)subpathApprox.get(0)).getY());
                float remainingDist = 0.0f;
                boolean remainingIsGap = false;
                for (int i = 1; i < subpathApprox.size(); ++i) {
                    nextPoint = null;
                    if (remainingDist != 0.0f) {
                        nextPoint = LineDashPattern.getNextPoint((Point)subpathApprox.get(i - 1), (Point)subpathApprox.get(i), remainingDist);
                        remainingDist = LineDashPattern.applyDash(dashedPath, (Point)subpathApprox.get(i - 1), (Point)subpathApprox.get(i), nextPoint, remainingIsGap);
                    }
                    while (Float.compare(remainingDist, 0.0f) == 0 && !dashedPath.getCurrentPoint().equals(subpathApprox.get(i))) {
                        DashArrayElem currentElem = lineDashPattern.next();
                        nextPoint = LineDashPattern.getNextPoint(nextPoint != null ? nextPoint : (Point)subpathApprox.get(i - 1), (Point)subpathApprox.get(i), currentElem.getVal());
                        remainingDist = LineDashPattern.applyDash(dashedPath, (Point)subpathApprox.get(i - 1), (Point)subpathApprox.get(i), nextPoint, currentElem.isGap());
                        remainingIsGap = currentElem.isGap();
                    }
                }
                if (modifiedSubpaths.contains(currentSubpath)) {
                    lineDashPattern.reset();
                    DashArrayElem currentElem = lineDashPattern.next();
                    nextPoint = LineDashPattern.getNextPoint((Point)subpathApprox.get(0), (Point)subpathApprox.get(1), currentElem.getVal());
                    LineDashPattern.applyDash(dashedPath, (Point)subpathApprox.get(0), (Point)subpathApprox.get(1), nextPoint, currentElem.isGap());
                }
            }
            lineDashPattern.reset();
            ++currentSubpath;
        }
        return dashedPath;
    }

    private static Point getNextPoint(Point segStart, Point segEnd, float dist) {
        Point vector = LineDashPattern.componentwiseDiff(segEnd, segStart);
        Point unitVector = LineDashPattern.getUnitVector(vector);
        return new Point(segStart.getX() + (double)dist * unitVector.getX(), segStart.getY() + (double)dist * unitVector.getY());
    }

    private static Point componentwiseDiff(Point minuend, Point subtrahend) {
        return new Point(minuend.getX() - subtrahend.getX(), minuend.getY() - subtrahend.getY());
    }

    private static Point getUnitVector(Point vector) {
        double vectorLength = LineDashPattern.getVectorEuclideanNorm(vector);
        return new Point(vector.getX() / vectorLength, vector.getY() / vectorLength);
    }

    private static double getVectorEuclideanNorm(Point vector) {
        return vector.distance(0.0, 0.0);
    }

    private static float applyDash(Path dashedPath, Point segStart, Point segEnd, Point dashTo, boolean isGap) {
        float remainingDist = 0.0f;
        if (!LineDashPattern.liesOnSegment(segStart, segEnd, dashTo)) {
            remainingDist = (float)dashTo.distance(segEnd);
            dashTo = segEnd;
        }
        if (isGap) {
            dashedPath.moveTo((float)dashTo.getX(), (float)dashTo.getY());
        } else {
            dashedPath.lineTo((float)dashTo.getX(), (float)dashTo.getY());
        }
        return remainingDist;
    }

    private static boolean liesOnSegment(Point segStart, Point segEnd, Point point) {
        return point.getX() >= Math.min(segStart.getX(), segEnd.getX()) && point.getX() <= Math.max(segStart.getX(), segEnd.getX()) && point.getY() >= Math.min(segStart.getY(), segEnd.getY()) && point.getY() <= Math.max(segStart.getY(), segEnd.getY());
    }

    public class DashArrayElem {
        private float val;
        private boolean isGap;

        DashArrayElem(float val, boolean isGap) {
            this.val = val;
            this.isGap = isGap;
        }

        float getVal() {
            return this.val;
        }

        void setVal(float val) {
            this.val = val;
        }

        boolean isGap() {
            return this.isGap;
        }

        void setGap(boolean isGap) {
            this.isGap = isGap;
        }
    }
}

