/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.util;

import com.itextpdf.kernel.geom.Point;
import com.itextpdf.kernel.geom.Rectangle;

public final class CleanUpHelperUtil {
    private static final float EPS = 1.0E-4f;

    private CleanUpHelperUtil() {
    }

    public static int[] getImageRectToClean(Rectangle rect, int imgWidth, int imgHeight) {
        double bottom = (double)rect.getBottom() * (double)imgHeight;
        int scaledBottomY = (int)Math.ceil(bottom - (double)1.0E-4f);
        double top = (double)rect.getTop() * (double)imgHeight;
        int scaledTopY = (int)Math.floor(top + (double)1.0E-4f);
        double left = (double)rect.getLeft() * (double)imgWidth;
        int x = (int)Math.ceil(left - (double)1.0E-4f);
        int y = imgHeight - scaledTopY;
        double right = (double)rect.getRight() * (double)imgWidth;
        int w = (int)Math.floor(right + (double)1.0E-4f) - x;
        int h = scaledTopY - scaledBottomY;
        return new int[]{x, y, w, h};
    }

    public static double calculatePolygonArea(Point[] vertices) {
        double sum = 0.0;
        for (int i = 0; i < vertices.length; ++i) {
            if (i == 0) {
                sum += vertices[i].x * (vertices[i + 1].y - vertices[vertices.length - 1].y);
                continue;
            }
            if (i == vertices.length - 1) {
                sum += vertices[i].x * (vertices[0].y - vertices[i - 1].y);
                continue;
            }
            sum += vertices[i].x * (vertices[i + 1].y - vertices[i - 1].y);
        }
        return 0.5 * Math.abs(sum);
    }
}

