/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.pdfcleanup.util;

import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.pdfcleanup.util.CleanUpHelperUtil;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.IIOImage;
import javax.imageio.ImageIO;
import javax.imageio.ImageWriteParam;
import javax.imageio.ImageWriter;
import javax.imageio.stream.MemoryCacheImageOutputStream;
import org.apache.commons.imaging.ImageFormat;
import org.apache.commons.imaging.ImageFormats;
import org.apache.commons.imaging.ImageInfo;
import org.apache.commons.imaging.ImageReadException;
import org.apache.commons.imaging.ImageWriteException;
import org.apache.commons.imaging.Imaging;

public final class CleanUpImageUtil {
    private static final Color CLEANED_AREA_FILL_COLOR = Color.WHITE;

    private CleanUpImageUtil() {
    }

    public static byte[] cleanUpImage(byte[] imageBytes, List<Rectangle> areasToBeCleaned) {
        if (areasToBeCleaned.isEmpty()) {
            return imageBytes;
        }
        try {
            ImageInfo imageInfo = Imaging.getImageInfo((byte[])imageBytes);
            BufferedImage image = CleanUpImageUtil.getBuffer(imageBytes, imageInfo.getFormat());
            CleanUpImageUtil.cleanImage(image, areasToBeCleaned);
            return CleanUpImageUtil.writeImage(image, imageInfo);
        }
        catch (IOException | ImageReadException | ImageWriteException e) {
            throw new CleanupImageHandlingUtilException(e.getMessage(), (Exception)e);
        }
    }

    private static void cleanImage(BufferedImage image, List<Rectangle> areasToBeCleaned) {
        Graphics2D graphics = image.createGraphics();
        graphics.setColor(CLEANED_AREA_FILL_COLOR);
        for (Rectangle rect : areasToBeCleaned) {
            int imgHeight = image.getHeight();
            int imgWidth = image.getWidth();
            int[] scaledRectToClean = CleanUpHelperUtil.getImageRectToClean(rect, imgWidth, imgHeight);
            graphics.fillRect(scaledRectToClean[0], scaledRectToClean[1], scaledRectToClean[2], scaledRectToClean[3]);
        }
        graphics.dispose();
    }

    private static BufferedImage getBuffer(byte[] imageBytes, ImageFormat imageFormat) throws IOException {
        try {
            if (imageFormat != ImageFormats.JPEG) {
                return Imaging.getBufferedImage((byte[])imageBytes);
            }
        }
        catch (ImageReadException imageReadException) {
            // empty catch block
        }
        return ImageIO.read(new ByteArrayInputStream(imageBytes));
    }

    private static byte[] writeImage(BufferedImage imageToWrite, ImageInfo originalImageInfo) throws IOException, ImageWriteException {
        if (originalImageInfo.getFormat() == ImageFormats.JPEG) {
            return CleanUpImageUtil.getJPGBytes(imageToWrite);
        }
        ConcurrentHashMap<String, Boolean> params = new ConcurrentHashMap<String, Boolean>();
        if (originalImageInfo.getFormat() == ImageFormats.PNG && originalImageInfo.getColorType() != ImageInfo.ColorType.GRAYSCALE) {
            params.put("PNG_FORCE_TRUE_COLOR", true);
        }
        return Imaging.writeImageToBytes((BufferedImage)imageToWrite, (ImageFormat)originalImageInfo.getFormat(), params);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static byte[] getJPGBytes(BufferedImage image) {
        try (ByteArrayOutputStream outputStream = new ByteArrayOutputStream();){
            ImageWriter jpgWriter = ImageIO.getImageWritersByFormatName("jpg").next();
            ImageWriteParam jpgWriteParam = jpgWriter.getDefaultWriteParam();
            jpgWriteParam.setCompressionMode(2);
            jpgWriteParam.setCompressionQuality(1.0f);
            jpgWriter.setOutput(new MemoryCacheImageOutputStream(outputStream));
            IIOImage outputImage = new IIOImage(image, null, null);
            jpgWriter.write(null, outputImage, jpgWriteParam);
            jpgWriter.dispose();
            outputStream.flush();
            byte[] byArray = outputStream.toByteArray();
            return byArray;
        }
        catch (IOException e) {
            throw new CleanupImageHandlingUtilException(e.getMessage(), e);
        }
    }

    public static class CleanupImageHandlingUtilException
    extends RuntimeException {
        public CleanupImageHandlingUtilException(String msg, Exception e) {
            super(msg, e);
        }
    }
}

