/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.forms.xfdf;

import com.itextpdf.io.source.ByteUtils;
import com.itextpdf.kernel.colors.Color;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfArray;
import com.itextpdf.kernel.pdf.annot.PdfAnnotation;
import com.itextpdf.kernel.pdf.colorspace.PdfColorSpace;
import com.itextpdf.kernel.pdf.colorspace.PdfDeviceCs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.StringTokenizer;

final class XfdfObjectUtils {
    private XfdfObjectUtils() {
    }

    static Rectangle convertRectFromString(String rectString) {
        String delims = ",";
        StringTokenizer st = new StringTokenizer(rectString, delims);
        ArrayList<String> coordsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            coordsList.add(st.nextToken());
        }
        if (coordsList.size() == 2) {
            return new Rectangle(Float.parseFloat((String)coordsList.get(0)), Float.parseFloat((String)coordsList.get(1)));
        }
        if (coordsList.size() == 4) {
            return new Rectangle(Float.parseFloat((String)coordsList.get(0)), Float.parseFloat((String)coordsList.get(1)), Float.parseFloat((String)coordsList.get(2)), Float.parseFloat((String)coordsList.get(3)));
        }
        return null;
    }

    static PdfArray convertFringeFromString(String fringeString) {
        String delims = ",";
        StringTokenizer st = new StringTokenizer(fringeString, delims);
        ArrayList<String> fringeList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            fringeList.add(st.nextToken());
        }
        float[] fringe = new float[4];
        if (fringeList.size() == 4) {
            for (int i = 0; i < 4; ++i) {
                fringe[i] = Float.parseFloat((String)fringeList.get(i));
            }
        }
        return new PdfArray(fringe);
    }

    static String convertRectToString(Rectangle rect) {
        return XfdfObjectUtils.convertFloatToString(rect.getX()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getY()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getX() + rect.getWidth()) + ", " + XfdfObjectUtils.convertFloatToString(rect.getY() + rect.getHeight());
    }

    static String convertFloatToString(float coord) {
        return new String(ByteUtils.getIsoBytes((double)coord));
    }

    static float[] convertQuadPointsFromCoordsString(String coordsString) {
        String delims = ",";
        StringTokenizer st = new StringTokenizer(coordsString, delims);
        ArrayList<String> quadPointsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            quadPointsList.add(st.nextToken());
        }
        if (quadPointsList.size() == 8) {
            float[] quadPoints = new float[8];
            for (int i = 0; i < 8; ++i) {
                quadPoints[i] = Float.parseFloat((String)quadPointsList.get(i));
            }
            return quadPoints;
        }
        return new float[0];
    }

    static String convertQuadPointsToCoordsString(float[] quadPoints) {
        StringBuilder stb = new StringBuilder(XfdfObjectUtils.floatToPaddedString(quadPoints[0]));
        for (int i = 1; i < 8; ++i) {
            stb.append(", ").append(XfdfObjectUtils.floatToPaddedString(quadPoints[i]));
        }
        return stb.toString();
    }

    private static String floatToPaddedString(float number) {
        return new String(ByteUtils.getIsoBytes((double)number));
    }

    static int convertFlagsFromString(String flagsString) {
        int result = 0;
        String delims = ",";
        StringTokenizer st = new StringTokenizer(flagsString, delims);
        ArrayList<String> flagsList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            flagsList.add(st.nextToken().toLowerCase());
        }
        HashMap<String, Integer> flagMap = new HashMap<String, Integer>();
        flagMap.put("invisible", 1);
        flagMap.put("hidden", 2);
        flagMap.put("print", 4);
        flagMap.put("nozoom", 8);
        flagMap.put("norotate", 16);
        flagMap.put("noview", 32);
        flagMap.put("readonly", 64);
        flagMap.put("locked", 128);
        flagMap.put("togglenoview", 256);
        for (String flag : flagsList) {
            if (!flagMap.containsKey(flag)) continue;
            result += ((Integer)flagMap.get(flag)).intValue();
        }
        return result;
    }

    static String convertFlagsToString(PdfAnnotation pdfAnnotation) {
        ArrayList<String> flagsList = new ArrayList<String>();
        StringBuilder stb = new StringBuilder();
        if (pdfAnnotation.hasFlag(1)) {
            flagsList.add("invisible");
        }
        if (pdfAnnotation.hasFlag(2)) {
            flagsList.add("hidden");
        }
        if (pdfAnnotation.hasFlag(4)) {
            flagsList.add("print");
        }
        if (pdfAnnotation.hasFlag(8)) {
            flagsList.add("nozoom");
        }
        if (pdfAnnotation.hasFlag(16)) {
            flagsList.add("norotate");
        }
        if (pdfAnnotation.hasFlag(32)) {
            flagsList.add("noview");
        }
        if (pdfAnnotation.hasFlag(64)) {
            flagsList.add("readonly");
        }
        if (pdfAnnotation.hasFlag(128)) {
            flagsList.add("locked");
        }
        if (pdfAnnotation.hasFlag(256)) {
            flagsList.add("togglenoview");
        }
        for (String flag : flagsList) {
            stb.append(flag).append(",");
        }
        String result = stb.toString();
        return result.length() > 0 ? result.substring(0, result.length() - 1) : null;
    }

    static String convertColorToString(float[] colors) {
        if (colors.length == 3) {
            return "#" + XfdfObjectUtils.convertColorFloatToHex(colors[0]) + XfdfObjectUtils.convertColorFloatToHex(colors[1]) + XfdfObjectUtils.convertColorFloatToHex(colors[2]);
        }
        return null;
    }

    static String convertColorToString(Color color) {
        float[] colors = color.getColorValue();
        if (colors != null && colors.length == 3) {
            return "#" + XfdfObjectUtils.convertColorFloatToHex(colors[0]) + XfdfObjectUtils.convertColorFloatToHex(colors[1]) + XfdfObjectUtils.convertColorFloatToHex(colors[2]);
        }
        return null;
    }

    private static String convertColorFloatToHex(float colorFloat) {
        String result = "0" + Integer.toHexString((int)((double)(colorFloat * 255.0f) + 0.5)).toUpperCase();
        return result.substring(result.length() - 2);
    }

    static String convertIdToHexString(String stringId) {
        char[] stringSymbols;
        StringBuilder stb = new StringBuilder();
        for (char ch : stringSymbols = stringId.toCharArray()) {
            stb.append(Integer.toHexString(ch).toUpperCase());
        }
        return stb.toString();
    }

    static Color convertColorFromString(String hexColor) {
        return Color.makeColor((PdfColorSpace)new PdfDeviceCs.Rgb(), (float[])XfdfObjectUtils.convertColorFloatsFromString(hexColor));
    }

    static float[] convertColorFloatsFromString(String colorHexString) {
        float[] result = new float[3];
        String colorString = colorHexString.substring(colorHexString.indexOf(35) + 1);
        if (colorString.length() == 6) {
            for (int i = 0; i < 3; ++i) {
                result[i] = Integer.parseInt(colorString.substring(i * 2, 2 + i * 2), 16);
            }
        }
        return result;
    }

    static String convertVerticesToString(float[] vertices) {
        if (vertices.length <= 0) {
            return null;
        }
        StringBuilder stb = new StringBuilder();
        stb.append(vertices[0]);
        for (int i = 1; i < vertices.length; ++i) {
            stb.append(", ").append(vertices[i]);
        }
        return stb.toString();
    }

    static String convertFringeToString(float[] fringeArray) {
        if (fringeArray.length != 4) {
            return null;
        }
        StringBuilder stb = new StringBuilder();
        stb.append(fringeArray[0]);
        for (int i = 1; i < 4; ++i) {
            stb.append(", ").append(fringeArray[i]);
        }
        return stb.toString();
    }

    static float[] convertVerticesFromString(String verticesString) {
        String delims = ",;";
        StringTokenizer st = new StringTokenizer(verticesString, delims);
        ArrayList<String> verticesList = new ArrayList<String>();
        while (st.hasMoreTokens()) {
            verticesList.add(st.nextToken());
        }
        float[] vertices = new float[verticesList.size()];
        for (int i = 0; i < verticesList.size(); ++i) {
            vertices[i] = Float.parseFloat((String)verticesList.get(i));
        }
        return vertices;
    }

    static String convertLineStartToString(float[] line) {
        if (line.length == 4) {
            return line[0] + "," + line[1];
        }
        return null;
    }

    static String convertLineEndToString(float[] line) {
        if (line.length == 4) {
            return line[2] + "," + line[3];
        }
        return null;
    }
}

