/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.IHtmlProcessor;
import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.FontFace;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.tags.HtmlTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.html2pdf.css.CssFontFaceRule;
import com.itextpdf.html2pdf.css.apply.ICssApplier;
import com.itextpdf.html2pdf.css.apply.util.PageBreakApplierUtil;
import com.itextpdf.html2pdf.css.pseudo.CssPseudoElementNode;
import com.itextpdf.html2pdf.css.pseudo.CssPseudoElementUtil;
import com.itextpdf.html2pdf.css.resolve.DefaultCssResolver;
import com.itextpdf.html2pdf.css.resolve.ICssResolver;
import com.itextpdf.html2pdf.exception.Html2PdfException;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.html2pdf.html.node.ITextNode;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.io.font.FontProgramFactory;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.Version;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.font.FontInfo;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultHtmlProcessor
implements IHtmlProcessor {
    private static final Logger logger = LoggerFactory.getLogger(DefaultHtmlProcessor.class);
    private static final Set<String> ignoredTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("head", "style", "tbody")));
    private static final Set<String> ignoredCssTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("br", "link", "meta", "title", "tr")));
    private static final Set<String> ignoredChildTags = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("body", "link", "meta", "script", "title")));
    private ProcessorContext context;
    private List<IPropertyContainer> roots;
    private ICssResolver cssResolver;

    public DefaultHtmlProcessor(ConverterProperties converterProperties) {
        this.context = new ProcessorContext(converterProperties);
    }

    @Override
    public List<IElement> processElements(INode root) {
        block4: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block4;
                throw new RuntimeException(e.getCause());
            }
        }
        this.context.reset();
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        IElementNode html = this.findHtmlNode(root);
        IElementNode body = this.findBodyNode(root);
        html.setStyles(this.cssResolver.resolveStyles(html, this.context.getCssContext()));
        this.visit(body);
        Div bodyDiv = (Div)this.roots.get(0);
        ArrayList<IElement> elements = new ArrayList<IElement>();
        for (IPropertyContainer propertyContainer : bodyDiv.getChildren()) {
            if (!(propertyContainer instanceof IElement)) continue;
            propertyContainer.setProperty(89, (Object)true);
            propertyContainer.setProperty(91, (Object)this.context.getFontProvider());
            if (this.context.getTempFonts() != null) {
                propertyContainer.setProperty(98, (Object)this.context.getTempFonts());
            }
            elements.add((IElement)propertyContainer);
        }
        this.cssResolver = null;
        this.roots = null;
        return elements;
    }

    @Override
    public Document processDocument(INode root, PdfDocument pdfDocument) {
        block4: {
            String licenseKeyClassName = "com.itextpdf.licensekey.LicenseKey";
            String licenseKeyProductClassName = "com.itextpdf.licensekey.LicenseKeyProduct";
            String licenseKeyFeatureClassName = "com.itextpdf.licensekey.LicenseKeyProductFeature";
            String checkLicenseKeyMethodName = "scheduledCheck";
            try {
                Class<?> licenseKeyClass = Class.forName(licenseKeyClassName);
                Class<?> licenseKeyProductClass = Class.forName(licenseKeyProductClassName);
                Class<?> licenseKeyProductFeatureClass = Class.forName(licenseKeyFeatureClassName);
                Object licenseKeyProductFeatureArray = Array.newInstance(licenseKeyProductFeatureClass, 0);
                Class[] params = new Class[]{String.class, Integer.TYPE, Integer.TYPE, licenseKeyProductFeatureArray.getClass()};
                Constructor<?> licenseKeyProductConstructor = licenseKeyProductClass.getConstructor(params);
                Object licenseKeyProductObject = licenseKeyProductConstructor.newInstance("pdfHtml", 1, 0, licenseKeyProductFeatureArray);
                Method method = licenseKeyClass.getMethod(checkLicenseKeyMethodName, licenseKeyProductClass);
                method.invoke(null, licenseKeyProductObject);
            }
            catch (Exception e) {
                if (Version.isAGPLVersion()) break block4;
                throw new RuntimeException(e.getCause());
            }
        }
        this.context.reset(pdfDocument);
        if (!this.context.hasFonts()) {
            throw new Html2PdfException("Font Provider contains zero fonts. At least one font shall be present");
        }
        this.roots = new ArrayList<IPropertyContainer>();
        this.cssResolver = new DefaultCssResolver(root, this.context);
        this.context.getLinkContext().scanForIds(root);
        this.addFontFaceFonts();
        root = this.findHtmlNode(root);
        this.visit(root);
        Document doc = (Document)this.roots.get(0);
        if (this.context.getCssContext().isPagesCounterPresent() && doc.getRenderer() instanceof HtmlDocumentRenderer) {
            doc.relayout();
        }
        this.cssResolver = null;
        this.roots = null;
        return doc;
    }

    private void visit(INode node) {
        String content;
        if (node instanceof IElementNode) {
            IElementNode element = (IElementNode)node;
            element.setStyles(this.cssResolver.resolveStyles(element, this.context.getCssContext()));
            if (!this.isDisplayable(element)) {
                return;
            }
            ITagWorker tagWorker = this.context.getTagWorkerFactory().getTagWorker(element, this.context);
            if (tagWorker == null) {
                if (!ignoredTags.contains(element.name())) {
                    logger.error(MessageFormatUtil.format((String)"No worker found for tag {0}", (Object[])new Object[]{element.name()}));
                }
            } else {
                this.context.getState().push(tagWorker);
            }
            if (tagWorker instanceof HtmlTagWorker) {
                ((HtmlTagWorker)tagWorker).processPageRules(node, this.cssResolver, this.context);
            }
            this.context.getOutlineHandler().addOutline(tagWorker, element, this.context);
            this.visitPseudoElement(element, "before");
            for (INode childNode : element.childNodes()) {
                this.visit(childNode);
            }
            this.visitPseudoElement(element, "after");
            if (tagWorker != null) {
                tagWorker.processEnd(element, this.context);
                LinkHelper.createDestination(tagWorker, element, this.context);
                this.context.getOutlineHandler().addDestination(tagWorker, element);
                this.context.getState().pop();
                ICssApplier cssApplier = this.context.getCssApplierFactory().getCssApplier(element);
                if (cssApplier == null) {
                    if (!ignoredCssTags.contains(element.name())) {
                        logger.error(MessageFormatUtil.format((String)"No css applier found for tag {0}", (Object[])new Object[]{element.name()}));
                    }
                } else {
                    cssApplier.apply(this.context, element, tagWorker);
                }
                if (!this.context.getState().empty()) {
                    PageBreakApplierUtil.addPageBreakElementBefore(this.context, this.context.getState().top(), element, tagWorker);
                    boolean childProcessed = this.context.getState().top().processTagChild(tagWorker, this.context);
                    PageBreakApplierUtil.addPageBreakElementAfter(this.context, this.context.getState().top(), element, tagWorker);
                    if (!childProcessed && !ignoredChildTags.contains(element.name())) {
                        logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process {1}", (Object[])new Object[]{this.context.getState().top().getClass().getName(), tagWorker.getClass().getName()}));
                    }
                } else if (tagWorker.getElementResult() != null) {
                    this.roots.add(tagWorker.getElementResult());
                }
            }
            element.setStyles(null);
        } else if (node instanceof ITextNode && (content = ((ITextNode)node).wholeText()) != null) {
            if (!this.context.getState().empty()) {
                boolean contentProcessed = this.context.getState().top().processContent(content, this.context);
                if (!contentProcessed) {
                    logger.error(MessageFormatUtil.format((String)"Worker of type {0} unable to process it's text content", (Object[])new Object[]{this.context.getState().top().getClass().getName()}));
                }
            } else {
                logger.error("No consumer found for content");
            }
        }
    }

    private void addFontFaceFonts() {
        if (this.cssResolver instanceof DefaultCssResolver) {
            for (CssFontFaceRule fontFace : ((DefaultCssResolver)this.cssResolver).getFonts()) {
                boolean findSupportedSrc = false;
                FontFace ff = FontFace.create(fontFace.getProperties());
                if (ff != null) {
                    for (FontFace.FontFaceSrc src : ff.getSources()) {
                        if (!this.createFont(ff.getFontFamily(), src)) continue;
                        findSupportedSrc = true;
                        break;
                    }
                }
                if (findSupportedSrc) continue;
                logger.error(MessageFormatUtil.format((String)"Unable to retrieve font:\n {0}", (Object[])new Object[]{fontFace}));
            }
        }
    }

    private boolean createFont(String fontFamily, FontFace.FontFaceSrc src) {
        if (!this.supportedFontFormat(src.format)) {
            return false;
        }
        if (src.isLocal) {
            Collection fonts = this.context.getFontProvider().getFontSet().get(src.src);
            if (fonts.size() > 0) {
                for (FontInfo fi : fonts) {
                    this.context.addTemporaryFont(fi, fontFamily);
                }
                return true;
            }
            return false;
        }
        try {
            byte[] bytes = this.context.getResourceResolver().retrieveStream(src.src);
            if (bytes != null) {
                FontProgram fp = FontProgramFactory.createFont((byte[])bytes, (boolean)false);
                this.context.addTemporaryFont(fp, "Identity-H", fontFamily);
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    private boolean supportedFontFormat(FontFace.FontFormat format) {
        switch (format) {
            case None: 
            case TrueType: 
            case OpenType: 
            case WOFF: 
            case WOFF2: {
                return true;
            }
        }
        return false;
    }

    private void visitPseudoElement(IElementNode node, String pseudoElementName) {
        if (CssPseudoElementUtil.hasBeforeAfterElements(node)) {
            this.visit(new CssPseudoElementNode(node, pseudoElementName));
        }
    }

    private IElementNode findElement(INode node, String tagName) {
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(node);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode && ((IElementNode)currentNode).name().equals(tagName)) {
                return (IElementNode)currentNode;
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }

    private IElementNode findHtmlNode(INode node) {
        return this.findElement(node, "html");
    }

    private IElementNode findBodyNode(INode node) {
        return this.findElement(node, "body");
    }

    private boolean isDisplayable(IElementNode element) {
        if (element != null && element.getStyles() != null && "none".equals(element.getStyles().get("display"))) {
            return false;
        }
        if (element instanceof CssPseudoElementNode) {
            if (element.childNodes().isEmpty()) {
                return false;
            }
            boolean hasStyles = element.getStyles() != null;
            String positionVal = hasStyles ? element.getStyles().get("position") : null;
            String displayVal = hasStyles ? element.getStyles().get("display") : null;
            boolean containsNonEmptyChildNode = false;
            boolean containsElementNode = false;
            for (int i = 0; i < element.childNodes().size(); ++i) {
                if (element.childNodes().get(i) instanceof ITextNode) {
                    containsNonEmptyChildNode = true;
                    break;
                }
                if (!(element.childNodes().get(i) instanceof IElementNode)) continue;
                containsElementNode = true;
            }
            return containsElementNode || containsNonEmptyChildNode || "absolute".equals(positionVal) || "fixed".equals(positionVal) || displayVal != null && !"inline".equals(displayVal);
        }
        return element != null;
    }
}

