/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.property.UnitValue;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PaddingApplierUtil {
    private static final Logger logger = LoggerFactory.getLogger(PaddingApplierUtil.class);

    private PaddingApplierUtil() {
    }

    public static void applyPaddings(Map<String, String> cssProps, ProcessorContext context, IPropertyContainer element) {
        String paddingTop = cssProps.get("padding-top");
        String paddingBottom = cssProps.get("padding-bottom");
        String paddingLeft = cssProps.get("padding-left");
        String paddingRight = cssProps.get("padding-right");
        float em = CssUtils.parseAbsoluteLength(cssProps.get("font-size"));
        float rem = context.getCssContext().getRootFontSize();
        UnitValue marginTopVal = CssUtils.parseLengthValueToPt(paddingTop, em, rem);
        UnitValue marginBottomVal = CssUtils.parseLengthValueToPt(paddingBottom, em, rem);
        UnitValue marginLeftVal = CssUtils.parseLengthValueToPt(paddingLeft, em, rem);
        UnitValue marginRightVal = CssUtils.parseLengthValueToPt(paddingRight, em, rem);
        if (marginTopVal != null) {
            if (marginTopVal.isPointValue()) {
                element.setProperty(50, (Object)Float.valueOf(marginTopVal.getValue()));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (marginBottomVal != null) {
            if (marginBottomVal.isPointValue()) {
                element.setProperty(47, (Object)Float.valueOf(marginBottomVal.getValue()));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (marginLeftVal != null) {
            if (marginLeftVal.isPointValue()) {
                element.setProperty(48, (Object)Float.valueOf(marginLeftVal.getValue()));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
        if (marginRightVal != null) {
            if (marginRightVal.isPointValue()) {
                element.setProperty(49, (Object)Float.valueOf(marginRightVal.getValue()));
            } else {
                logger.error("Padding value in percents not supported");
            }
        }
    }
}

