/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.tags.DivTagWorker;
import com.itextpdf.html2pdf.attach.util.LinkHelper;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.resolver.resource.UriResolver;
import com.itextpdf.kernel.pdf.PdfName;
import com.itextpdf.layout.element.Div;
import java.net.MalformedURLException;

public class ABlockTagWorker
extends DivTagWorker {
    public ABlockTagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        super.processEnd(element, context);
        String url = element.getAttribute("href");
        if (url != null) {
            String base = context.getBaseUri();
            if (base != null) {
                UriResolver uriResolver = new UriResolver(base);
                if (!url.startsWith("#") || !uriResolver.isLocalBaseUri()) {
                    try {
                        String resolvedUri = uriResolver.resolveAgainstBaseUri(url).toExternalForm();
                        if (!url.endsWith("/") && resolvedUri.endsWith("/")) {
                            resolvedUri = resolvedUri.substring(0, resolvedUri.length() - 1);
                        }
                        if (!resolvedUri.startsWith("file:")) {
                            url = resolvedUri;
                        }
                    }
                    catch (MalformedURLException malformedURLException) {
                        // empty catch block
                    }
                }
            }
            ((Div)this.getElementResult()).setRole(PdfName.Link);
            LinkHelper.applyLinkAnnotation(this.getElementResult(), url);
        }
        if (this.getElementResult() != null) {
            String name = element.getAttribute("name");
            this.getElementResult().setProperty(17, (Object)name);
        }
    }
}

