/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css;

import com.itextpdf.html2pdf.css.CssAtRule;
import com.itextpdf.html2pdf.css.CssDeclaration;
import com.itextpdf.html2pdf.css.CssRuleSet;
import com.itextpdf.html2pdf.css.CssStatement;
import com.itextpdf.html2pdf.css.media.MediaDeviceDescription;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.io.util.MessageFormatUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

public class CssNestedAtRule
extends CssAtRule {
    private String ruleParameters;
    protected List<CssStatement> body;

    public CssNestedAtRule(String ruleName, String ruleParameters) {
        super(ruleName);
        this.ruleParameters = ruleParameters;
        this.body = new ArrayList<CssStatement>();
    }

    public void addStatementToBody(CssStatement statement) {
        this.body.add(statement);
    }

    public void addStatementsToBody(Collection<CssStatement> statements) {
        this.body.addAll(statements);
    }

    public void addBodyCssDeclarations(List<CssDeclaration> cssDeclarations) {
    }

    @Override
    public List<CssRuleSet> getCssRuleSets(INode node, MediaDeviceDescription deviceDescription) {
        ArrayList<CssRuleSet> result = new ArrayList<CssRuleSet>();
        for (CssStatement childStatement : this.body) {
            result.addAll(childStatement.getCssRuleSets(node, deviceDescription));
        }
        return result;
    }

    public List<CssStatement> getStatements() {
        return this.body;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(MessageFormatUtil.format((String)"@{0} {1} ", (Object[])new Object[]{this.ruleName, this.ruleParameters}));
        sb.append("{");
        sb.append("\n");
        for (int i = 0; i < this.body.size(); ++i) {
            sb.append("    ");
            sb.append(this.body.get(i).toString().replace("\n", "\n    "));
            if (i == this.body.size() - 1) continue;
            sb.append("\n");
        }
        sb.append("\n}");
        return sb.toString();
    }

    public String getRuleParameters() {
        return this.ruleParameters;
    }
}

