/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.html.impl.jsoup;

import com.itextpdf.html2pdf.html.IHtmlParser;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupDataNode;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupDocumentNode;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupDocumentTypeNode;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupElementNode;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupNode;
import com.itextpdf.html2pdf.html.impl.jsoup.node.JsoupTextNode;
import com.itextpdf.html2pdf.html.node.IDocumentNode;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.io.util.MessageFormatUtil;
import java.io.IOException;
import java.io.InputStream;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Comment;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.DocumentType;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupHtmlParser
implements IHtmlParser {
    private static Logger logger = LoggerFactory.getLogger(JsoupHtmlParser.class);

    @Override
    public IDocumentNode parse(InputStream htmlStream, String charset) throws IOException {
        String baseUri = "";
        Document doc = Jsoup.parse(htmlStream, charset, baseUri);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    @Override
    public IDocumentNode parse(String html) {
        Document doc = Jsoup.parse(html);
        INode result = this.wrapJsoupHierarchy(doc);
        if (result instanceof IDocumentNode) {
            return (IDocumentNode)result;
        }
        throw new IllegalStateException();
    }

    private INode wrapJsoupHierarchy(Node jsoupNode) {
        JsoupNode resultNode = null;
        if (jsoupNode instanceof Document) {
            resultNode = new JsoupDocumentNode((Document)jsoupNode);
        } else if (jsoupNode instanceof TextNode) {
            resultNode = new JsoupTextNode((TextNode)jsoupNode);
        } else if (jsoupNode instanceof Element) {
            resultNode = new JsoupElementNode((Element)jsoupNode);
        } else if (jsoupNode instanceof DataNode) {
            resultNode = new JsoupDataNode((DataNode)jsoupNode);
        } else if (jsoupNode instanceof DocumentType) {
            resultNode = new JsoupDocumentTypeNode((DocumentType)jsoupNode);
        } else if (!(jsoupNode instanceof Comment)) {
            logger.error(MessageFormatUtil.format((String)"Could not map node type: {0}", (Object[])new Object[]{jsoupNode.getClass()}));
        }
        for (Node node : jsoupNode.childNodes()) {
            INode childNode = this.wrapJsoupHierarchy(node);
            if (childNode == null) continue;
            resultNode.addChild(childNode);
        }
        return resultNode;
    }
}

