/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.resolve;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.CssDeclaration;
import com.itextpdf.html2pdf.css.CssFontFaceRule;
import com.itextpdf.html2pdf.css.CssStatement;
import com.itextpdf.html2pdf.css.CssStyleSheet;
import com.itextpdf.html2pdf.css.apply.util.CounterProcessorUtil;
import com.itextpdf.html2pdf.css.apply.util.FontStyleApplierUtil;
import com.itextpdf.html2pdf.css.media.CssMediaRule;
import com.itextpdf.html2pdf.css.media.MediaDeviceDescription;
import com.itextpdf.html2pdf.css.page.PageMarginBoxContextNode;
import com.itextpdf.html2pdf.css.parse.CssRuleSetParser;
import com.itextpdf.html2pdf.css.parse.CssStyleSheetParser;
import com.itextpdf.html2pdf.css.pseudo.CssPseudoElementNode;
import com.itextpdf.html2pdf.css.resolve.CssContentPropertyResolver;
import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.css.resolve.CssDefaults;
import com.itextpdf.html2pdf.css.resolve.CssInheritance;
import com.itextpdf.html2pdf.css.resolve.CssPropertyMerger;
import com.itextpdf.html2pdf.css.resolve.HtmlStylesToCssConverter;
import com.itextpdf.html2pdf.css.resolve.ICssResolver;
import com.itextpdf.html2pdf.css.resolve.UserAgentCss;
import com.itextpdf.html2pdf.css.resolve.shorthand.IShorthandResolver;
import com.itextpdf.html2pdf.css.resolve.shorthand.ShorthandResolverFactory;
import com.itextpdf.html2pdf.css.util.CssUtils;
import com.itextpdf.html2pdf.css.validate.CssDeclarationValidationMaster;
import com.itextpdf.html2pdf.html.HtmlUtils;
import com.itextpdf.html2pdf.html.node.IDataNode;
import com.itextpdf.html2pdf.html.node.IDocumentNode;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import com.itextpdf.html2pdf.html.node.IStylesContainer;
import com.itextpdf.html2pdf.resolver.resource.ResourceResolver;
import com.itextpdf.io.util.DecimalFormatUtil;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.io.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCssResolver
implements ICssResolver {
    private CssStyleSheet cssStyleSheet;
    private MediaDeviceDescription deviceDescription;
    private List<CssFontFaceRule> fonts = new ArrayList<CssFontFaceRule>();

    public DefaultCssResolver(INode treeRoot, MediaDeviceDescription mediaDeviceDescription, ResourceResolver resourceResolver) {
        this.deviceDescription = mediaDeviceDescription;
        this.collectCssDeclarations(treeRoot, resourceResolver, null);
        this.collectFonts();
    }

    public DefaultCssResolver(INode treeRoot, ProcessorContext context) {
        this.deviceDescription = context.getDeviceDescription();
        this.collectCssDeclarations(treeRoot, context.getResourceResolver(), context.getCssContext());
        this.collectFonts();
    }

    @Override
    public Map<String, String> resolveStyles(INode element, CssContext context) {
        String elementFontSize;
        String styleAttribute;
        List<CssDeclaration> nodeCssDeclarations = UserAgentCss.getStyles(element);
        if (element instanceof IElementNode) {
            nodeCssDeclarations.addAll(HtmlStylesToCssConverter.convert((IElementNode)element));
        }
        nodeCssDeclarations.addAll(this.cssStyleSheet.getCssDeclarations(element, this.deviceDescription));
        if (element instanceof IElementNode && (styleAttribute = ((IElementNode)element).getAttribute("style")) != null) {
            nodeCssDeclarations.addAll(CssRuleSetParser.parsePropertyDeclarations(styleAttribute));
        }
        Map<String, String> elementStyles = this.cssDeclarationsToMap(nodeCssDeclarations);
        String parentFontSizeStr = null;
        if (element.parentNode() instanceof IStylesContainer) {
            IStylesContainer parentNode = (IStylesContainer)((Object)element.parentNode());
            Map<String, String> parentStyles = parentNode.getStyles();
            if (parentStyles == null && !(element.parentNode() instanceof IDocumentNode)) {
                Logger logger = LoggerFactory.getLogger(DefaultCssResolver.class);
                logger.error("Element parent styles are not resolved. Styles for current element might be incorrect.");
            }
            if (parentStyles != null) {
                for (Map.Entry<String, String> entry : parentStyles.entrySet()) {
                    this.mergeParentCssDeclaration(elementStyles, (String)entry.getKey(), (String)entry.getValue());
                }
                parentFontSizeStr = parentStyles.get("font-size");
            }
        }
        if (CssUtils.isRelativeValue(elementFontSize = elementStyles.get("font-size")) || "larger".equals(elementFontSize) || "smaller".equals(elementFontSize)) {
            float baseFontSize = CssUtils.isRemValue(elementFontSize) ? context.getRootFontSize() : (parentFontSizeStr == null ? FontStyleApplierUtil.parseAbsoluteFontSize(CssDefaults.getDefaultValue("font-size")) : CssUtils.parseAbsoluteLength(parentFontSizeStr));
            float absoluteFontSize = FontStyleApplierUtil.parseRelativeFontSize(elementFontSize, baseFontSize);
            elementStyles.put("font-size", DecimalFormatUtil.formatNumber((double)absoluteFontSize, (String)"0.####") + "pt");
        } else {
            elementStyles.put("font-size", Float.toString(FontStyleApplierUtil.parseAbsoluteFontSize(elementFontSize)) + "pt");
        }
        if (element instanceof IElementNode && "html".equals(((IElementNode)element).name())) {
            context.setRootFontSize(elementStyles.get("font-size"));
        }
        HashSet<String> keys = new HashSet<String>();
        for (Map.Entry<String, String> entry : elementStyles.entrySet()) {
            if (!"initial".equals(entry.getValue()) && !"inherit".equals(entry.getValue())) continue;
            keys.add(entry.getKey());
        }
        for (String key : keys) {
            elementStyles.put(key, CssDefaults.getDefaultValue(key));
        }
        CounterProcessorUtil.processCounters(elementStyles, context, element);
        this.resolveContentProperty(elementStyles, element, context);
        return elementStyles;
    }

    public List<CssFontFaceRule> getFonts() {
        return this.fonts;
    }

    private void resolveContentProperty(Map<String, String> styles, INode contentContainer, CssContext context) {
        List<INode> resolvedContent;
        if ((contentContainer instanceof CssPseudoElementNode || contentContainer instanceof PageMarginBoxContextNode) && (resolvedContent = CssContentPropertyResolver.resolveContent(styles, contentContainer, context)) != null) {
            for (INode child : resolvedContent) {
                contentContainer.addChild(child);
            }
        }
    }

    private Map<String, String> cssDeclarationsToMap(List<CssDeclaration> nodeCssDeclarations) {
        HashMap<String, String> stylesMap = new HashMap<String, String>();
        for (CssDeclaration cssDeclaration : nodeCssDeclarations) {
            IShorthandResolver shorthandResolver = ShorthandResolverFactory.getShorthandResolver(cssDeclaration.getProperty());
            if (shorthandResolver == null) {
                this.putDeclarationInMapIfValid(stylesMap, cssDeclaration);
                continue;
            }
            List<CssDeclaration> resolvedShorthandProps = shorthandResolver.resolveShorthand(cssDeclaration.getExpression());
            for (CssDeclaration resolvedProp : resolvedShorthandProps) {
                this.putDeclarationInMapIfValid(stylesMap, resolvedProp);
            }
        }
        return stylesMap;
    }

    private void putDeclarationInMapIfValid(Map<String, String> stylesMap, CssDeclaration cssDeclaration) {
        if (CssDeclarationValidationMaster.checkDeclaration(cssDeclaration)) {
            stylesMap.put(cssDeclaration.getProperty(), cssDeclaration.getExpression());
        } else {
            Logger logger = LoggerFactory.getLogger(DefaultCssResolver.class);
            logger.warn(MessageFormatUtil.format((String)"Invalid css property declaration: {0}", (Object[])new Object[]{cssDeclaration}));
        }
    }

    private INode collectCssDeclarations(INode rootNode, ResourceResolver resourceResolver, CssContext cssContext) {
        this.cssStyleSheet = new CssStyleSheet();
        LinkedList<INode> q = new LinkedList<INode>();
        q.add(rootNode);
        while (!q.isEmpty()) {
            INode currentNode = (INode)q.getFirst();
            q.removeFirst();
            if (currentNode instanceof IElementNode) {
                IElementNode headChildElement = (IElementNode)currentNode;
                if (headChildElement.name().equals("style")) {
                    if (currentNode.childNodes().size() > 0 && currentNode.childNodes().get(0) instanceof IDataNode) {
                        String styleData = ((IDataNode)currentNode.childNodes().get(0)).getWholeData();
                        this.checkIfPagesCounterMentioned(styleData, cssContext);
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse(styleData);
                        styleSheet = this.wrapStyleSheetInMediaQueryIfNecessary(headChildElement, styleSheet);
                        this.cssStyleSheet.appendCssStyleSheet(styleSheet);
                    }
                } else if (HtmlUtils.isStyleSheetLink(headChildElement)) {
                    String styleSheetUri = headChildElement.getAttribute("href");
                    try {
                        InputStream stream = resourceResolver.retrieveStyleSheet(styleSheetUri);
                        byte[] bytes = StreamUtil.inputStreamToArray((InputStream)stream);
                        this.checkIfPagesCounterMentioned(new String(bytes), cssContext);
                        CssStyleSheet styleSheet = CssStyleSheetParser.parse(new ByteArrayInputStream(bytes), resourceResolver.resolveAgainstBaseUri(styleSheetUri).toExternalForm());
                        styleSheet = this.wrapStyleSheetInMediaQueryIfNecessary(headChildElement, styleSheet);
                        this.cssStyleSheet.appendCssStyleSheet(styleSheet);
                    }
                    catch (Exception exc) {
                        Logger logger = LoggerFactory.getLogger(DefaultCssResolver.class);
                        logger.error("Unable to process external css file", (Throwable)exc);
                    }
                }
            }
            for (INode child : currentNode.childNodes()) {
                if (!(child instanceof IElementNode)) continue;
                q.add(child);
            }
        }
        return null;
    }

    private void checkIfPagesCounterMentioned(String cssContents, CssContext cssContext) {
        if (cssContents.contains("counter(pages)") || cssContents.contains("counters(pages")) {
            cssContext.setPagesCounterPresent(true);
        }
    }

    private CssStyleSheet wrapStyleSheetInMediaQueryIfNecessary(IElementNode headChildElement, CssStyleSheet styleSheet) {
        String mediaAttribute = headChildElement.getAttribute("media");
        if (mediaAttribute != null && mediaAttribute.length() > 0) {
            CssMediaRule mediaRule = new CssMediaRule(mediaAttribute);
            mediaRule.addStatementsToBody(styleSheet.getStatements());
            styleSheet = new CssStyleSheet();
            styleSheet.addStatement(mediaRule);
        }
        return styleSheet;
    }

    private void mergeParentCssDeclaration(Map<String, String> styles, String cssProperty, String parentPropValue) {
        String childPropValue = styles.get(cssProperty);
        if (childPropValue == null && CssInheritance.isInheritable(cssProperty) || "inherit".equals(childPropValue)) {
            styles.put(cssProperty, parentPropValue);
        } else if ("text-decoration".equals(cssProperty) && !"inline-block".equals(styles.get("display"))) {
            styles.put(cssProperty, CssPropertyMerger.mergeTextDecoration(childPropValue, parentPropValue));
        }
    }

    private void collectFonts() {
        for (CssStatement cssStatement : this.cssStyleSheet.getStatements()) {
            this.collectFonts(cssStatement);
        }
    }

    private void collectFonts(CssStatement cssStatement) {
        if (cssStatement instanceof CssFontFaceRule) {
            this.fonts.add((CssFontFaceRule)cssStatement);
        } else if (cssStatement instanceof CssMediaRule && ((CssMediaRule)cssStatement).matchMediaDevice(this.deviceDescription)) {
            for (CssStatement cssSubStatement : ((CssMediaRule)cssStatement).getStatements()) {
                this.collectFonts(cssSubStatement);
            }
        }
    }
}

