/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.selector.item;

import com.itextpdf.html2pdf.css.parse.CssSelectorParser;
import com.itextpdf.html2pdf.css.selector.CssSelector;
import com.itextpdf.html2pdf.css.selector.ICssSelector;
import com.itextpdf.html2pdf.css.selector.item.CssPseudoElementSelectorItem;
import com.itextpdf.html2pdf.css.selector.item.ICssSelectorItem;
import com.itextpdf.html2pdf.html.node.ICustomElementNode;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.INode;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class CssPseudoClassSelectorItem
implements ICssSelectorItem {
    protected String arguments;
    private String pseudoClass;

    protected CssPseudoClassSelectorItem(String pseudoClass) {
        this(pseudoClass, "");
    }

    protected CssPseudoClassSelectorItem(String pseudoClass, String arguments) {
        this.pseudoClass = pseudoClass;
        this.arguments = arguments;
    }

    public static CssPseudoClassSelectorItem create(String fullSelectorString) {
        String arguments;
        String pseudoClass;
        int indexOfParentheses = fullSelectorString.indexOf(40);
        if (indexOfParentheses == -1) {
            pseudoClass = fullSelectorString;
            arguments = "";
        } else {
            pseudoClass = fullSelectorString.substring(0, indexOfParentheses);
            arguments = fullSelectorString.substring(indexOfParentheses + 1, fullSelectorString.length() - 1).trim();
        }
        return CssPseudoClassSelectorItem.create(pseudoClass, arguments);
    }

    public static CssPseudoClassSelectorItem create(String pseudoClass, String arguments) {
        switch (pseudoClass) {
            case "first-child": {
                return FirstChildSelectorItem.getInstance();
            }
            case "last-child": {
                return LastChildSelectorItem.getInstance();
            }
            case "nth-child": {
                return new NthChildSelectorItem(arguments);
            }
            case "not": {
                CssSelector selector = new CssSelector(arguments);
                for (ICssSelectorItem item : selector.getSelectorItems()) {
                    if (!(item instanceof NotSelectorItem) && !(item instanceof CssPseudoElementSelectorItem)) continue;
                    return null;
                }
                return new NotSelectorItem(selector);
            }
            case "link": {
                return new AlwaysApplySelectorItem(pseudoClass, arguments);
            }
            case "active": 
            case "focus": 
            case "hover": 
            case "target": 
            case "visited": {
                return new AlwaysNotApplySelectorItem(pseudoClass, arguments);
            }
        }
        return null;
    }

    @Override
    public int getSpecificity() {
        return 1024;
    }

    @Override
    public boolean matches(INode node) {
        return false;
    }

    public String toString() {
        return ":" + this.pseudoClass + (!this.arguments.isEmpty() ? "(" + this.arguments + ")" : "");
    }

    public String getPseudoClass() {
        return this.pseudoClass;
    }

    private static class AlwaysNotApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysNotApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return false;
        }
    }

    private static class AlwaysApplySelectorItem
    extends CssPseudoClassSelectorItem {
        AlwaysApplySelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        @Override
        public boolean matches(INode node) {
            return true;
        }
    }

    private static class NotSelectorItem
    extends CssPseudoClassSelectorItem {
        private ICssSelector argumentsSelector;

        NotSelectorItem(ICssSelector argumentsSelector) {
            super("not", argumentsSelector.toString());
            this.argumentsSelector = argumentsSelector;
        }

        public List<ICssSelectorItem> getArgumentsSelector() {
            return CssSelectorParser.parseSelectorItems(this.arguments);
        }

        @Override
        public boolean matches(INode node) {
            return !this.argumentsSelector.matches(node);
        }
    }

    private static class NthChildSelectorItem
    extends ChildSelectorItem {
        private int nthChildA;
        private int nthChildB;

        NthChildSelectorItem(String arguments) {
            super("nth-child", arguments);
            this.getNthChildArguments();
        }

        @Override
        public boolean matches(INode node) {
            if (!(node instanceof IElementNode) || node instanceof ICustomElementNode) {
                return false;
            }
            List<INode> children = this.getAllSiblings(node);
            return !children.isEmpty() && this.resolveNthChild(node, children);
        }

        private void getNthChildArguments() {
            if (this.arguments.matches("((-|\\+)?[0-9]*n(\\s*(-|\\+)\\s*[0-9]+)?|(-|\\+)?[0-9]+|odd|even)")) {
                if (this.arguments.equals("odd")) {
                    this.nthChildA = 2;
                    this.nthChildB = 1;
                } else if (this.arguments.equals("even")) {
                    this.nthChildA = 2;
                    this.nthChildB = 0;
                } else {
                    int indexOfN = this.arguments.indexOf(110);
                    if (indexOfN == -1) {
                        this.nthChildA = 0;
                        this.nthChildB = Integer.valueOf(this.arguments);
                    } else {
                        String aParticle = this.arguments.substring(0, indexOfN).trim();
                        this.nthChildA = aParticle.isEmpty() ? 0 : (aParticle.length() == 1 && !Character.isDigit(aParticle.charAt(0)) ? (aParticle.equals("+") ? 1 : -1) : Integer.valueOf(aParticle));
                        String bParticle = this.arguments.substring(indexOfN + 1).trim();
                        this.nthChildB = !bParticle.isEmpty() ? Integer.valueOf(bParticle.charAt(0) + bParticle.substring(1).trim()) : 0;
                    }
                }
            } else {
                this.nthChildA = 0;
                this.nthChildB = 0;
            }
        }

        private boolean resolveNthChild(INode node, List<INode> children) {
            if (!children.contains(node)) {
                return false;
            }
            if (this.nthChildA > 0) {
                int temp = children.indexOf(node) + 1 - this.nthChildB;
                return temp >= 0 && temp % this.nthChildA == 0;
            }
            if (this.nthChildA < 0) {
                int temp = children.indexOf(node) + 1 - this.nthChildB;
                return temp <= 0 && temp % this.nthChildA == 0;
            }
            return children.indexOf(node) + 1 - this.nthChildB == 0;
        }
    }

    private static class LastChildSelectorItem
    extends ChildSelectorItem {
        private static final LastChildSelectorItem instance = new LastChildSelectorItem();

        private LastChildSelectorItem() {
            super("last-child");
        }

        public static LastChildSelectorItem getInstance() {
            return instance;
        }

        @Override
        public boolean matches(INode node) {
            if (!(node instanceof IElementNode) || node instanceof ICustomElementNode) {
                return false;
            }
            List<INode> children = this.getAllSiblings(node);
            return !children.isEmpty() && node.equals(children.get(children.size() - 1));
        }
    }

    private static class FirstChildSelectorItem
    extends ChildSelectorItem {
        private static final FirstChildSelectorItem instance = new FirstChildSelectorItem();

        private FirstChildSelectorItem() {
            super("first-child");
        }

        public static FirstChildSelectorItem getInstance() {
            return instance;
        }

        @Override
        public boolean matches(INode node) {
            if (!(node instanceof IElementNode) || node instanceof ICustomElementNode) {
                return false;
            }
            List<INode> children = this.getAllSiblings(node);
            return !children.isEmpty() && node.equals(children.get(0));
        }
    }

    private static class ChildSelectorItem
    extends CssPseudoClassSelectorItem {
        ChildSelectorItem(String pseudoClass) {
            super(pseudoClass);
        }

        ChildSelectorItem(String pseudoClass, String arguments) {
            super(pseudoClass, arguments);
        }

        List<INode> getAllSiblings(INode node) {
            INode parentElement = node.parentNode();
            if (parentElement != null) {
                List<INode> childrenUnmodifiable = parentElement.childNodes();
                ArrayList<INode> children = new ArrayList<INode>(childrenUnmodifiable.size());
                for (INode iNode : childrenUnmodifiable) {
                    if (!(iNode instanceof IElementNode)) continue;
                    children.add(iNode);
                }
                return children;
            }
            return Collections.emptyList();
        }
    }
}

