/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach;

import com.itextpdf.html2pdf.ConverterProperties;
import com.itextpdf.html2pdf.attach.ITagWorkerFactory;
import com.itextpdf.html2pdf.attach.State;
import com.itextpdf.html2pdf.attach.impl.DefaultTagWorkerFactory;
import com.itextpdf.html2pdf.attach.impl.LinkContext;
import com.itextpdf.html2pdf.attach.impl.OutlineHandler;
import com.itextpdf.html2pdf.css.apply.ICssApplierFactory;
import com.itextpdf.html2pdf.css.apply.impl.DefaultCssApplierFactory;
import com.itextpdf.html2pdf.css.media.MediaDeviceDescription;
import com.itextpdf.html2pdf.css.resolve.CssContext;
import com.itextpdf.html2pdf.resolver.font.DefaultFontProvider;
import com.itextpdf.html2pdf.resolver.form.FormFieldNameResolver;
import com.itextpdf.html2pdf.resolver.form.RadioCheckResolver;
import com.itextpdf.html2pdf.resolver.resource.ResourceResolver;
import com.itextpdf.io.font.FontProgram;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.font.FontInfo;
import com.itextpdf.layout.font.FontProvider;
import com.itextpdf.layout.font.FontSet;

public class ProcessorContext {
    private FontProvider fontProvider;
    private FontSet tempFonts;
    private ResourceResolver resourceResolver;
    private MediaDeviceDescription deviceDescription;
    private ITagWorkerFactory tagWorkerFactory;
    private ICssApplierFactory cssApplierFactory;
    private String baseUri;
    private boolean createAcroForm;
    private FormFieldNameResolver formFieldNameResolver;
    private RadioCheckResolver radioCheckResolver;
    private OutlineHandler outlineHandler;
    private boolean immediateFlush;
    private State state;
    private CssContext cssContext;
    private LinkContext linkContext;
    private PdfDocument pdfDocument;

    public ProcessorContext(ConverterProperties converterProperties) {
        if (converterProperties == null) {
            converterProperties = new ConverterProperties();
        }
        this.state = new State();
        this.deviceDescription = converterProperties.getMediaDeviceDescription();
        if (this.deviceDescription == null) {
            this.deviceDescription = MediaDeviceDescription.getDefault();
        }
        this.fontProvider = converterProperties.getFontProvider();
        if (this.fontProvider == null) {
            this.fontProvider = new DefaultFontProvider();
        }
        this.tagWorkerFactory = converterProperties.getTagWorkerFactory();
        if (this.tagWorkerFactory == null) {
            this.tagWorkerFactory = DefaultTagWorkerFactory.getInstance();
        }
        this.cssApplierFactory = converterProperties.getCssApplierFactory();
        if (this.cssApplierFactory == null) {
            this.cssApplierFactory = DefaultCssApplierFactory.getInstance();
        }
        this.baseUri = converterProperties.getBaseUri();
        if (this.baseUri == null) {
            this.baseUri = "";
        }
        this.outlineHandler = converterProperties.getOutlineHandler();
        if (this.outlineHandler == null) {
            this.outlineHandler = new OutlineHandler();
        }
        this.resourceResolver = new ResourceResolver(this.baseUri);
        this.cssContext = new CssContext();
        this.linkContext = new LinkContext();
        this.createAcroForm = converterProperties.isCreateAcroForm();
        this.formFieldNameResolver = new FormFieldNameResolver();
        this.radioCheckResolver = new RadioCheckResolver();
        this.immediateFlush = converterProperties.isImmediateFlush();
    }

    public void setFontProvider(FontProvider fontProvider) {
        this.fontProvider = fontProvider;
    }

    public State getState() {
        return this.state;
    }

    public PdfDocument getPdfDocument() {
        return this.pdfDocument;
    }

    public FontProvider getFontProvider() {
        return this.fontProvider;
    }

    public FontSet getTempFonts() {
        return this.tempFonts;
    }

    public ResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public MediaDeviceDescription getDeviceDescription() {
        return this.deviceDescription;
    }

    public ITagWorkerFactory getTagWorkerFactory() {
        return this.tagWorkerFactory;
    }

    public ICssApplierFactory getCssApplierFactory() {
        return this.cssApplierFactory;
    }

    public CssContext getCssContext() {
        return this.cssContext;
    }

    public LinkContext getLinkContext() {
        return this.linkContext;
    }

    public boolean isCreateAcroForm() {
        return this.createAcroForm;
    }

    public FormFieldNameResolver getFormFieldNameResolver() {
        return this.formFieldNameResolver;
    }

    public RadioCheckResolver getRadioCheckResolver() {
        return this.radioCheckResolver;
    }

    public OutlineHandler getOutlineHandler() {
        return this.outlineHandler;
    }

    public void addTemporaryFont(FontInfo fontInfo, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontInfo, alias);
    }

    public void addTemporaryFont(FontProgram fontProgram, String encoding, String alias) {
        if (this.tempFonts == null) {
            this.tempFonts = new FontSet();
        }
        this.tempFonts.addFont(fontProgram, encoding, alias);
    }

    public boolean hasFonts() {
        return !this.fontProvider.getFontSet().isEmpty() || this.tempFonts != null && !this.tempFonts.isEmpty();
    }

    public void reset() {
        this.pdfDocument = null;
        this.state = new State();
        this.resourceResolver.resetCache();
        this.cssContext = new CssContext();
        this.linkContext = new LinkContext();
        this.formFieldNameResolver.reset();
        this.fontProvider = new FontProvider(this.fontProvider.getFontSet());
        this.tempFonts = null;
        this.outlineHandler.reset();
    }

    public void reset(PdfDocument pdfDocument) {
        this.reset();
        this.pdfDocument = pdfDocument;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public boolean isImmediateFlush() {
        return this.immediateFlush;
    }
}

