/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.apply.util;

import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.css.resolve.CssDefaults;
import com.itextpdf.html2pdf.html.node.IElementNode;
import com.itextpdf.html2pdf.html.node.IStylesContainer;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.hyphenation.HyphenationConfig;
import java.util.Map;

public final class HyphenationApplierUtil {
    private static final int HYPHENATE_BEFORE = 2;
    private static final int HYPHENATE_AFTER = 3;

    private HyphenationApplierUtil() {
    }

    public static void applyHyphenation(Map<String, String> cssProps, ProcessorContext context, IStylesContainer stylesContainer, IPropertyContainer element) {
        String lang;
        String value = cssProps.get("hyphens");
        if (value == null) {
            value = CssDefaults.getDefaultValue("hyphens");
        }
        if ("none".equals(value)) {
            element.setProperty(30, null);
        } else if ("manual".equals(value)) {
            element.setProperty(30, (Object)new HyphenationConfig(2, 3));
        } else if ("auto".equals(value) && stylesContainer instanceof IElementNode && (lang = ((IElementNode)stylesContainer).getLang()) != null && lang.length() > 0) {
            element.setProperty(30, (Object)new HyphenationConfig(lang.substring(0, 2), "", 2, 3));
        }
    }
}

