/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.css.validate.impl.datatype;

import com.itextpdf.html2pdf.css.validate.ICssDataTypeValidator;

public class CssTransformValidator
implements ICssDataTypeValidator {
    @Override
    public boolean isValid(String objectString) {
        String[] components;
        if ("none".equals(objectString)) {
            return true;
        }
        for (String component : components = objectString.split("\\)")) {
            if (this.isValidComponent(component)) continue;
            return false;
        }
        return true;
    }

    private boolean isValidComponent(String objectString) {
        String[] arg;
        if ("none".equals(objectString) || objectString.indexOf(40) <= 0) {
            return false;
        }
        String function = objectString.substring(0, objectString.indexOf(40)).trim();
        String args = objectString.substring(objectString.indexOf(40) + 1);
        if ("matrix".equals(function) || "scale".equals(function) || "scalex".equals(function) || "scaley".equals(function)) {
            String[] arg2 = args.split(",");
            if (arg2.length == 6 && "matrix".equals(function) || (arg2.length == 1 || arg2.length == 2) && "scale".equals(function) || arg2.length == 1 && ("scalex".equals(function) || "scaley".equals(function))) {
                int i;
                for (i = 0; i < arg2.length; ++i) {
                    try {
                        Float.parseFloat(arg2[i].trim());
                        continue;
                    }
                    catch (NumberFormatException exc) {
                        return false;
                    }
                }
                if (i == arg2.length) {
                    return true;
                }
            }
            return false;
        }
        if ("translate".equals(function) || "translatex".equals(function) || "translatey".equals(function)) {
            String[] arg3 = args.split(",");
            if (arg3.length == 1 || arg3.length == 2 && "translate".equals(function) || arg3.length == 1 && ("translatex".equals(function) || "translatey".equals(function))) {
                for (String a : arg3) {
                    if (CssTransformValidator.isValidForTranslate(a)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }
        if ("rotate".equals(function)) {
            try {
                float value = Float.parseFloat(args);
                if (value == 0.0f) {
                    return true;
                }
            }
            catch (NumberFormatException value) {
                // empty catch block
            }
            int deg = args.indexOf(100);
            int rad = args.indexOf(114);
            if (deg > 0 && args.substring(deg).equals("deg") || rad > 0 && args.substring(rad).equals("rad")) {
                try {
                    Double.parseDouble(args.substring(0, deg > 0 ? deg : rad));
                }
                catch (NumberFormatException exc) {
                    return false;
                }
                return true;
            }
            return false;
        }
        if (("skew".equals(function) || "skewx".equals(function) || "skewy".equals(function)) && ((arg = args.split(",")).length == 1 || arg.length == 2 && "skew".equals(function) || arg.length == 1 && ("skewx".equals(function) || "skewy".equals(function)))) {
            for (int k = 0; k < arg.length; ++k) {
                try {
                    float value = Float.parseFloat(arg[k]);
                    if (value != 0.0f) {
                        return false;
                    }
                }
                catch (NumberFormatException value) {
                    // empty catch block
                }
                int deg = arg[k].indexOf(100);
                int rad = arg[k].indexOf(114);
                if (deg < 0 && rad < 0) {
                    return false;
                }
                if (deg > 0 && !arg[k].substring(deg).equals("deg") && rad < 0 || rad > 0 && !arg[k].substring(rad).equals("rad")) {
                    return false;
                }
                try {
                    Float.parseFloat(arg[k].trim().substring(0, rad > 0 ? rad : deg));
                    continue;
                }
                catch (NumberFormatException exc) {
                    return false;
                }
            }
            return true;
        }
        return false;
    }

    private static boolean isValidForTranslate(String string) {
        int pos;
        if (string == null) {
            return false;
        }
        for (pos = 0; pos < string.length() && (string.charAt(pos) == '+' || string.charAt(pos) == '-' || string.charAt(pos) == '.' || string.charAt(pos) >= '0' && string.charAt(pos) <= '9'); ++pos) {
        }
        if (pos > 0) {
            try {
                Float.parseFloat(string.substring(0, pos));
            }
            catch (NumberFormatException exc) {
                return false;
            }
            return Float.parseFloat(string.substring(0, pos)) == 0.0f || string.substring(pos).equals("pt") || string.substring(pos).equals("in") || string.substring(pos).equals("cm") || string.substring(pos).equals("q") || string.substring(pos).equals("mm") || string.substring(pos).equals("pc") || string.substring(pos).equals("px") || string.substring(pos).equals("%");
        }
        return false;
    }
}

