/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.HtmlDocumentRenderer;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.tags.BrTagWorker;
import com.itextpdf.html2pdf.attach.impl.tags.IDisplayAware;
import com.itextpdf.html2pdf.attach.impl.tags.SpanTagWorker;
import com.itextpdf.html2pdf.attach.util.WaitingInlineElementsHelper;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.layout.Document;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.AreaBreak;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.ILeafElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.layout.font.FontFamilySplitter;
import com.itextpdf.layout.renderer.DocumentRenderer;
import com.itextpdf.styledxmlparser.css.ICssResolver;
import com.itextpdf.styledxmlparser.node.IElementNode;
import com.itextpdf.styledxmlparser.node.INode;
import java.util.List;

public class HtmlTagWorker
implements ITagWorker {
    private Document document;
    private WaitingInlineElementsHelper inlineHelper;

    public HtmlTagWorker(IElementNode element, ProcessorContext context) {
        boolean immediateFlush = context.isImmediateFlush() && !context.getCssContext().isPagesCounterPresent();
        PdfDocument pdfDocument = context.getPdfDocument();
        this.document = new Document(pdfDocument, pdfDocument.getDefaultPageSize(), immediateFlush);
        this.document.setRenderer((DocumentRenderer)new HtmlDocumentRenderer(this.document, immediateFlush));
        this.document.setProperty(89, (Object)true);
        this.document.setFontProvider(context.getFontProvider());
        if (context.getTempFonts() != null) {
            this.document.setProperty(98, (Object)context.getTempFonts());
        }
        String fontFamily = (String)element.getStyles().get("font-family");
        List fontFamilies = FontFamilySplitter.splitFontFamily((String)fontFamily);
        this.document.setProperty(20, (Object)fontFamilies.toArray(new String[fontFamilies.size()]));
        this.inlineHelper = new WaitingInlineElementsHelper((String)element.getStyles().get("white-space"), (String)element.getStyles().get("text-transform"));
    }

    @Override
    public void processEnd(IElementNode element, ProcessorContext context) {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.document);
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.inlineHelper.add(content);
        return true;
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        boolean processed = false;
        if (childTagWorker instanceof SpanTagWorker) {
            boolean allChildrenProcessed = true;
            for (IPropertyContainer propertyContainer : ((SpanTagWorker)childTagWorker).getAllElements()) {
                if (propertyContainer instanceof ILeafElement) {
                    this.inlineHelper.add((ILeafElement)propertyContainer);
                    continue;
                }
                if (propertyContainer instanceof IBlockElement && "inline-block".equals(((SpanTagWorker)childTagWorker).getElementDisplay(propertyContainer))) {
                    this.inlineHelper.add((IBlockElement)propertyContainer);
                    continue;
                }
                allChildrenProcessed = this.processBlockChild(propertyContainer) && allChildrenProcessed;
            }
            processed = allChildrenProcessed;
        } else if (!(!(childTagWorker.getElementResult() instanceof IFormField) || childTagWorker instanceof IDisplayAware && "block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()))) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            processed = true;
        } else if (childTagWorker.getElementResult() instanceof AreaBreak) {
            this.postProcessInlineGroup();
            this.document.add((AreaBreak)childTagWorker.getElementResult());
            processed = true;
        } else if (childTagWorker instanceof IDisplayAware && "inline-block".equals(((IDisplayAware)((Object)childTagWorker)).getDisplay()) && childTagWorker.getElementResult() instanceof IBlockElement) {
            this.inlineHelper.add((IBlockElement)childTagWorker.getElementResult());
            processed = true;
        } else if (childTagWorker instanceof BrTagWorker) {
            this.inlineHelper.add((ILeafElement)childTagWorker.getElementResult());
            processed = true;
        } else if (childTagWorker.getElementResult() != null) {
            processed = this.processBlockChild(childTagWorker.getElementResult());
        }
        return processed;
    }

    @Override
    public IPropertyContainer getElementResult() {
        return this.document;
    }

    public void processPageRules(INode rootNode, ICssResolver cssResolver, ProcessorContext context) {
        ((HtmlDocumentRenderer)this.document.getRenderer()).processPageRules(rootNode, cssResolver, context);
    }

    private boolean processBlockChild(IPropertyContainer element) {
        this.postProcessInlineGroup();
        if (element instanceof IBlockElement) {
            this.document.add((IBlockElement)element);
            return true;
        }
        if (element instanceof Image) {
            this.document.add((Image)element);
            return true;
        }
        return false;
    }

    private void postProcessInlineGroup() {
        this.inlineHelper.flushHangingLeaves((IPropertyContainer)this.document);
    }
}

