/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.tags;

import com.itextpdf.html2pdf.attach.ITagWorker;
import com.itextpdf.html2pdf.attach.ProcessorContext;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.Button;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.ButtonContainer;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.IFormField;
import com.itextpdf.html2pdf.attach.impl.tags.DivTagWorker;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.IElement;
import com.itextpdf.layout.element.Image;
import com.itextpdf.styledxmlparser.node.IElementNode;

public class ButtonTagWorker
extends DivTagWorker {
    private static final String DEFAULT_BUTTON_NAME = "Button";
    private IFormField formField;
    private StringBuilder fallbackContent = new StringBuilder();
    private String name;
    private boolean flatten;
    private boolean hasChildren = false;

    public ButtonTagWorker(IElementNode element, ProcessorContext context) {
        super(element, context);
        String name = element.getAttribute("id");
        if (name == null) {
            name = DEFAULT_BUTTON_NAME;
        }
        this.name = context.getFormFieldNameResolver().resolveFormName(name);
        this.flatten = !context.isCreateAcroForm();
    }

    @Override
    public boolean processContent(String content, ProcessorContext context) {
        this.fallbackContent.append(content);
        return super.processContent(content, context);
    }

    @Override
    public boolean processTagChild(ITagWorker childTagWorker, ProcessorContext context) {
        this.hasChildren = true;
        return super.processTagChild(childTagWorker, context);
    }

    @Override
    public IPropertyContainer getElementResult() {
        if (this.formField == null) {
            if (this.hasChildren) {
                ButtonContainer button = new ButtonContainer(this.name);
                Div div = (Div)super.getElementResult();
                for (IElement element : div.getChildren()) {
                    if (element instanceof IBlockElement) {
                        button.add((IBlockElement)element);
                        continue;
                    }
                    if (!(element instanceof Image)) continue;
                    button.add((Image)element);
                }
                div.getChildren().clear();
                this.formField = button;
            } else {
                Button inputButton = new Button(this.name);
                inputButton.setProperty(0x100005, this.fallbackContent.toString().trim());
                this.formField = inputButton;
            }
        }
        this.formField.setProperty(0x100003, this.flatten);
        return this.formField;
    }
}

