/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.forms.PdfAcroForm;
import com.itextpdf.forms.fields.PdfButtonFormField;
import com.itextpdf.forms.fields.PdfFormField;
import com.itextpdf.html2pdf.attach.impl.layout.form.element.InputButton;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractOneLineTextFieldRenderer;
import com.itextpdf.io.util.MessageFormatUtil;
import com.itextpdf.kernel.font.PdfFont;
import com.itextpdf.kernel.geom.Rectangle;
import com.itextpdf.kernel.pdf.PdfDocument;
import com.itextpdf.kernel.pdf.PdfPage;
import com.itextpdf.layout.layout.LayoutContext;
import com.itextpdf.layout.property.Background;
import com.itextpdf.layout.property.UnitValue;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.renderer.LineRenderer;
import com.itextpdf.layout.renderer.ParagraphRenderer;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InputButtonRenderer
extends AbstractOneLineTextFieldRenderer {
    private boolean isSplit = false;

    public InputButtonRenderer(InputButton modelElement) {
        super(modelElement);
    }

    public IRenderer getNextRenderer() {
        return new InputButtonRenderer((InputButton)this.modelElement);
    }

    @Override
    protected void adjustFieldLayout(LayoutContext layoutContext) {
        List flatLines = ((ParagraphRenderer)this.flatRenderer).getLines();
        Rectangle flatBBox = this.flatRenderer.getOccupiedArea().getBBox();
        this.updatePdfFont((ParagraphRenderer)this.flatRenderer);
        if (!flatLines.isEmpty() && this.font != null) {
            if (flatLines.size() != 1) {
                this.isSplit = true;
            }
            this.cropContentLines(flatLines, flatBBox);
            Float width = this.retrieveWidth(layoutContext.getArea().getBBox().getWidth());
            if (width == null) {
                LineRenderer drawnLine = (LineRenderer)flatLines.get(0);
                drawnLine.move(flatBBox.getX() - drawnLine.getOccupiedArea().getBBox().getX(), 0.0f);
                flatBBox.setWidth(drawnLine.getOccupiedArea().getBBox().getWidth());
            }
        } else {
            LoggerFactory.getLogger(((Object)((Object)this)).getClass()).error(MessageFormatUtil.format((String)"Error during layout of form filed with type {0}.", (Object[])new Object[]{"button"}));
            this.setProperty(0x100003, true);
            flatBBox.setY(flatBBox.getTop()).setHeight(0.0f);
        }
    }

    @Override
    protected IRenderer createFlatRenderer() {
        return this.createParagraphRenderer(this.getDefaultValue());
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
        String value = this.getDefaultValue();
        String name = this.getModelId();
        UnitValue fontSize = this.getPropertyAsUnitValue(24);
        if (!fontSize.isPointValue()) {
            Logger logger = LoggerFactory.getLogger(InputButtonRenderer.class);
            logger.error(MessageFormatUtil.format((String)"Property {0} in percents is not supported", (Object[])new Object[]{24}));
        }
        PdfDocument doc = drawContext.getDocument();
        Rectangle area = this.flatRenderer.getOccupiedArea().getBBox().clone();
        this.applyPaddings(area, true);
        PdfPage page = doc.getPage(this.occupiedArea.getPageNumber());
        PdfButtonFormField button = PdfFormField.createPushButton((PdfDocument)doc, (Rectangle)area, (String)name, (String)value, (PdfFont)this.font, (float)fontSize.getValue());
        Background background = (Background)this.getProperty(6);
        if (background != null && background.getColor() != null) {
            button.setBackgroundColor(background.getColor());
        }
        this.applyDefaultFieldProperties((PdfFormField)button);
        PdfAcroForm.getAcroForm((PdfDocument)doc, (boolean)true).addField((PdfFormField)button, page);
        this.writeAcroFormFieldLangAttribute(doc);
    }

    @Override
    protected boolean isRendererFit(float availableWidth, float availableHeight) {
        return !this.isSplit && super.isRendererFit(availableWidth, availableHeight);
    }
}

