/*
 * Decompiled with CFR 0.152.
 */
package com.itextpdf.html2pdf.attach.impl.layout.form.renderer;

import com.itextpdf.html2pdf.attach.impl.layout.form.element.AbstractSelectField;
import com.itextpdf.html2pdf.attach.impl.layout.form.renderer.AbstractSelectFieldRenderer;
import com.itextpdf.html2pdf.attach.util.AccessiblePropHelper;
import com.itextpdf.layout.IPropertyContainer;
import com.itextpdf.layout.element.Div;
import com.itextpdf.layout.element.IBlockElement;
import com.itextpdf.layout.element.Paragraph;
import com.itextpdf.layout.minmaxwidth.MinMaxWidth;
import com.itextpdf.layout.properties.OverflowPropertyValue;
import com.itextpdf.layout.properties.VerticalAlignment;
import com.itextpdf.layout.renderer.DrawContext;
import com.itextpdf.layout.renderer.IRenderer;
import com.itextpdf.layout.tagging.IAccessibleElement;
import java.util.ArrayList;
import java.util.List;

public class SelectFieldComboBoxRenderer
extends AbstractSelectFieldRenderer {
    private IRenderer minMaxWidthRenderer;

    public SelectFieldComboBoxRenderer(AbstractSelectField modelElement) {
        super(modelElement);
        this.setProperty(75, VerticalAlignment.MIDDLE);
        this.setProperty(103, OverflowPropertyValue.HIDDEN);
        this.setProperty(104, OverflowPropertyValue.HIDDEN);
        this.minMaxWidthRenderer = this.createFlatRenderer(true);
    }

    public IRenderer getNextRenderer() {
        return new SelectFieldComboBoxRenderer((AbstractSelectField)this.modelElement);
    }

    public MinMaxWidth getMinMaxWidth() {
        List realChildRenderers = this.childRenderers;
        this.childRenderers = new ArrayList();
        this.childRenderers.add(this.minMaxWidthRenderer);
        MinMaxWidth minMaxWidth = super.getMinMaxWidth();
        this.childRenderers = realChildRenderers;
        return minMaxWidth;
    }

    protected boolean allowLastYLineRecursiveExtraction() {
        return true;
    }

    @Override
    protected IRenderer createFlatRenderer() {
        return this.createFlatRenderer(false);
    }

    @Override
    protected void applyAcroField(DrawContext drawContext) {
    }

    private IRenderer createFlatRenderer(boolean addAllOptionsToChildren) {
        AbstractSelectField selectField = (AbstractSelectField)this.modelElement;
        List<IBlockElement> options = selectField.getOptions();
        Div pseudoContainer = new Div();
        for (IBlockElement option : options) {
            pseudoContainer.add(option);
        }
        IRenderer pseudoRendererSubTree = pseudoContainer.createRendererSubTree();
        List<Paragraph> allOptions = addAllOptionsToChildren ? this.getAllOptionsFlatElements(pseudoRendererSubTree) : this.getSingleSelectedOptionFlatRenderer(pseudoRendererSubTree);
        if (allOptions.isEmpty()) {
            allOptions.add(SelectFieldComboBoxRenderer.createComboBoxOptionFlatElement());
        }
        pseudoContainer.getChildren().clear();
        for (Paragraph option : allOptions) {
            pseudoContainer.add((IBlockElement)option);
        }
        AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)pseudoContainer, this.getLang());
        IRenderer rendererSubTree = pseudoContainer.createRendererSubTree();
        return rendererSubTree;
    }

    private List<Paragraph> getSingleSelectedOptionFlatRenderer(IRenderer optionsSubTree) {
        ArrayList<Paragraph> selectedOptionFlatRendererList = new ArrayList<Paragraph>();
        List<IRenderer> selectedOptions = this.getOptionsMarkedSelected(optionsSubTree);
        IRenderer selectedOption = selectedOptions.isEmpty() ? this.getFirstOption(optionsSubTree) : selectedOptions.get(selectedOptions.size() - 1);
        if (selectedOption != null) {
            String label = (String)selectedOption.getProperty(0x10000E);
            Paragraph p = SelectFieldComboBoxRenderer.createComboBoxOptionFlatElement(label, false);
            this.processLangAttribute(p, selectedOption);
            selectedOptionFlatRendererList.add(p);
        }
        return selectedOptionFlatRendererList;
    }

    private IRenderer getFirstOption(IRenderer renderer) {
        IRenderer firstOption = null;
        for (IRenderer child : renderer.getChildRenderers()) {
            if (SelectFieldComboBoxRenderer.isOptionRenderer(child)) {
                firstOption = child;
                break;
            }
            firstOption = this.getFirstOption(child);
            if (firstOption == null) continue;
            break;
        }
        return firstOption;
    }

    private List<Paragraph> getAllOptionsFlatElements(IRenderer renderer) {
        return this.getAllOptionsFlatElements(renderer, false);
    }

    private List<Paragraph> getAllOptionsFlatElements(IRenderer renderer, boolean isInOptGroup) {
        ArrayList<Paragraph> options = new ArrayList<Paragraph>();
        for (IRenderer child : renderer.getChildRenderers()) {
            if (SelectFieldComboBoxRenderer.isOptionRenderer(child)) {
                String label = (String)child.getProperty(0x10000E);
                options.add(SelectFieldComboBoxRenderer.createComboBoxOptionFlatElement(label, isInOptGroup));
                continue;
            }
            options.addAll(this.getAllOptionsFlatElements(child, isInOptGroup || SelectFieldComboBoxRenderer.isOptGroupRenderer(child)));
        }
        return options;
    }

    private static Paragraph createComboBoxOptionFlatElement() {
        return SelectFieldComboBoxRenderer.createComboBoxOptionFlatElement(null, false);
    }

    private static Paragraph createComboBoxOptionFlatElement(String label, boolean simulateOptGroupMargin) {
        Paragraph paragraph = (Paragraph)new Paragraph().setMargin(0.0f);
        if (simulateOptGroupMargin) {
            paragraph.add("\u200d    ");
        }
        if (label == null || label.isEmpty()) {
            label = "\u00a0";
        }
        paragraph.add(label);
        paragraph.setProperty(103, (Object)OverflowPropertyValue.VISIBLE);
        paragraph.setProperty(104, (Object)OverflowPropertyValue.VISIBLE);
        float leftRightPaddingVal = 1.5f;
        float bottomPaddingVal = 0.75f;
        float topPaddingVal = 0.0f;
        paragraph.setPaddings(topPaddingVal, leftRightPaddingVal, bottomPaddingVal, leftRightPaddingVal);
        return paragraph;
    }

    private void processLangAttribute(Paragraph optionFlatElement, IRenderer originalOptionRenderer) {
        IPropertyContainer propertyContainer = originalOptionRenderer.getModelElement();
        if (propertyContainer instanceof IAccessibleElement) {
            String lang = ((IAccessibleElement)propertyContainer).getAccessibilityProperties().getLanguage();
            AccessiblePropHelper.trySetLangAttribute((IAccessibleElement)optionFlatElement, lang);
        }
    }
}

